/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.modules.indxp.InDXpActions;
import de.admadic.calculator.modules.indxp.InDXpCfg;
import de.admadic.calculator.modules.indxp.core.Factor;
import de.admadic.calculator.modules.indxp.core.InDXpData;
import de.admadic.calculator.modules.indxp.core.InDXpDataIO;
import de.admadic.calculator.modules.indxp.core.TabularCopyPasteCore;
import de.admadic.calculator.modules.indxp.core.XmlIoError;
import de.admadic.calculator.modules.indxp.ui.ExpResultsPanel;
import de.admadic.calculator.modules.indxp.ui.FactorInteractionsPanel;
import de.admadic.calculator.modules.indxp.ui.FactorsPanel;
import de.admadic.calculator.modules.indxp.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.indxp.ui.LevelAnalysisPanel;
import de.admadic.calculator.modules.indxp.ui.RunsPanel;
import de.admadic.calculator.modules.indxp.ui.SettingsDialog;
import de.admadic.calculator.modules.indxp.ui.WizardPanel;
import de.admadic.ui.util.AboutDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;

public class InDXpFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    boolean DBGtesting = false;
    InDXpCfg cfg;
    IAppContext appContext;
    String title;
    JPanel panelMain;
    WizardPanel wizardPanel;
    FactorsPanel factorsPanel;
    FactorInteractionsPanel factorInteractionsPanel;
    RunsPanel runsPanel;
    ExpResultsPanel expResultsPanel;
    JPanel panelLevelAnalysis;
    LevelAnalysisPanel levelAnalysisYAvgPanel;
    LevelAnalysisPanel levelAnalysisSigmaPanel;
    InDXpData ideData;
    InDXpActions actions;
    ImageIcon iconSmall;
    ImageIcon iconLarge;
    FloatingPointFormatter fpf;
    JMenuBar menuBar;
    static final String CMD_FILE_NEW = "mnu.file.new";
    static final String CMD_FILE_LOAD = "mnu.file.load";
    static final String CMD_FILE_SAVE = "mnu.file.save";
    static final String CMD_FILE_SAVEAS = "mnu.file.saveas";
    static final String CMD_FILE_EXPORT_TXT = "mnu.file.export.txt";
    static final String CMD_FILE_EXIT = "mnu.file.exit";
    static final String CMD_EDIT_COPY = "mnu.edit.copy";
    static final String CMD_EDIT_PASTE = "mnu.edit.paste";
    static final String CMD_EDIT_RNDDATA = "mnu.edit.rnddata";
    static final String CMD_TOOLS_OPTIONS = "mnu.tools.options";
    static final String CMD_HELP_ABOUT = "mnu.help.about";

    public InDXpFrame(InDXpCfg inDXpCfg, InDXpActions inDXpActions, IAppContext iAppContext) {
        this.appContext = iAppContext;
        this.cfg = inDXpCfg;
        this.actions = inDXpActions;
        this.fpf = FloatingPointFormatter.createSimpleFormatter();
        String string = inDXpCfg.getDisplayFormat();
        if (string == null) {
            string = "%g";
        }
        this.fpf.setFormatString(string);
        string = System.getProperty("admadic.testing");
        if (string != null && string.toLowerCase().equals("yes")) {
            this.DBGtesting = true;
        }
        this.initComponents();
    }

    private void addMenuItem(JMenu jMenu, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(this);
    }

    public ImageIcon loadIcon(String string) {
        String string2 = "de/admadic/calculator/modules/indxp/res/" + string;
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            if (this.logger != null) {
                this.logger.warning("could not get url for " + string2 + " (icon name = " + string + ")");
            }
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image == null) {
            if (this.logger != null) {
                this.logger.warning("could not get image for " + uRL.toString() + " (icon name = " + string + ")");
            }
            return null;
        }
        return new ImageIcon(image);
    }

    private void initComponents() {
        this.panelMain = (JPanel)this.getContentPane();
        this.iconSmall = this.loadIcon("icon-16.png");
        this.iconLarge = this.loadIcon("icon-48.png");
        if (this.iconSmall != null) {
            this.setIconImage(this.iconSmall.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                InDXpFrame.this.setVisible(false);
            }
        });
        this.title = "InDXp Module";
        this.setTitleImpl();
        BorderLayout borderLayout = new BorderLayout();
        this.panelMain.setLayout(borderLayout);
        this.wizardPanel = new WizardPanel();
        this.panelMain.add((Component)this.wizardPanel, "Center");
        this.ideData = new InDXpData();
        if (this.DBGtesting) {
            this.ideData.getFactorList().add(new Factor("A", "Temperature", "\u00b0C", "10", "20"));
            this.ideData.getFactorList().add(new Factor("B", "Pressure", "psi", "5", "10"));
            this.ideData.getFactorList().add(new Factor("C", "Diameter", "mm", "1.5", "1.7"));
        }
        this.factorsPanel = new FactorsPanel();
        this.wizardPanel.addPanel(this.factorsPanel, "Factors");
        this.factorsPanel.linkData(this.ideData.getFactorList());
        this.factorsPanel.setDataEventDispatcher(this.ideData);
        this.factorsPanel.setDataEventServer(this.ideData);
        this.factorsPanel.setDataItemStatusServer(this.ideData);
        this.factorInteractionsPanel = new FactorInteractionsPanel();
        this.wizardPanel.addPanel(this.factorInteractionsPanel, "Factor Interactions");
        this.factorInteractionsPanel.linkData(this.ideData.getFactorInteractionList(), this.ideData.getFactorList());
        this.factorInteractionsPanel.setDataEventDispatcher(this.ideData);
        this.factorInteractionsPanel.setDataEventServer(this.ideData);
        this.factorInteractionsPanel.setFactorInteractionBuilder(this.ideData.getFactorInteractionBuilder());
        this.factorInteractionsPanel.setDataItemStatusServer(this.ideData);
        this.runsPanel = new RunsPanel();
        this.wizardPanel.addPanel(this.runsPanel, "Runs");
        this.runsPanel.linkData(this.ideData.getRunList(), this.ideData.getFactorInteractionList());
        this.runsPanel.setDataEventDispatcher(this.ideData);
        this.runsPanel.setDataEventServer(this.ideData);
        this.runsPanel.setRunsBuilder(this.ideData.getRunsBuilder());
        this.runsPanel.setDataItemStatusServer(this.ideData);
        this.expResultsPanel = new ExpResultsPanel(this.fpf);
        this.wizardPanel.addPanel(this.expResultsPanel, "Exp. Results");
        this.expResultsPanel.linkData(this.ideData.getExpResultsList(), this.ideData.getRunList());
        this.expResultsPanel.setDataEventDispatcher(this.ideData);
        this.expResultsPanel.setDataEventServer(this.ideData);
        this.expResultsPanel.setDataItemStatusServer(this.ideData);
        this.panelLevelAnalysis = new JPanel();
        this.panelLevelAnalysis.setLayout(new FormLayout("p:grow", "p:grow, 5px, p:grow"));
        this.wizardPanel.addPanel(this.panelLevelAnalysis, "Level Analysis");
        this.levelAnalysisYAvgPanel = new LevelAnalysisPanel(this.fpf);
        this.panelLevelAnalysis.add((Component)this.levelAnalysisYAvgPanel, new CellConstraints(1, 1));
        this.levelAnalysisYAvgPanel.linkData(this.ideData.getLevelAnalysisYAvg(), this.ideData.getExpResultsList(), this.ideData.getFactorInteractionList());
        this.levelAnalysisYAvgPanel.setDataEventDispatcher(this.ideData);
        this.levelAnalysisYAvgPanel.setDataEventServer(this.ideData);
        this.levelAnalysisSigmaPanel = new LevelAnalysisPanel(this.fpf);
        this.panelLevelAnalysis.add((Component)this.levelAnalysisSigmaPanel, new CellConstraints(1, 3));
        this.levelAnalysisSigmaPanel.linkData(this.ideData.getLevelAnalysisSigma(), this.ideData.getExpResultsList(), this.ideData.getFactorInteractionList());
        this.levelAnalysisSigmaPanel.setDataEventDispatcher(this.ideData);
        this.levelAnalysisSigmaPanel.setDataEventServer(this.ideData);
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        this.menuBar.add(jMenu);
        this.addMenuItem(jMenu, "New", CMD_FILE_NEW);
        jMenu.add(new JSeparator());
        this.addMenuItem(jMenu, "Load...", CMD_FILE_LOAD);
        this.addMenuItem(jMenu, "Save", CMD_FILE_SAVE);
        this.addMenuItem(jMenu, "Save As...", CMD_FILE_SAVEAS);
        this.addMenuItem(jMenu, "Export as Text...", CMD_FILE_EXPORT_TXT);
        jMenu.add(new JSeparator());
        this.addMenuItem(jMenu, "Close", CMD_FILE_EXIT);
        jMenu = new JMenu("Edit");
        this.menuBar.add(jMenu);
        this.addMenuItem(jMenu, "Copy", CMD_EDIT_COPY);
        this.addMenuItem(jMenu, "Paste", CMD_EDIT_PASTE);
        if (this.DBGtesting) {
            jMenu.add(new JSeparator());
            this.addMenuItem(jMenu, "Create Random Results", CMD_EDIT_RNDDATA);
        }
        if (this.actions != null && this.actions.getActions() != null) {
            JMenu jMenu2 = new JMenu("Module");
            this.menuBar.add(jMenu2);
            for (int i = 1; i < this.actions.getActions().size(); ++i) {
                jMenu2.add(new JMenuItem(this.actions.getActions().get(i)));
            }
        }
        jMenu = new JMenu("Help");
        this.menuBar.add(jMenu);
        this.addMenuItem(jMenu, "About...", CMD_HELP_ABOUT);
        this.setJMenuBar(this.menuBar);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_EDIT_RNDDATA)) {
            this.ideData.createRandomResults();
        } else if (string.equals(CMD_FILE_NEW)) {
            if (this.ideData.isDirty() && !this.checkSave()) {
                return;
            }
            this.ideData.resetData();
        } else if (string.equals(CMD_FILE_LOAD)) {
            if (this.ideData.isDirty() && !this.checkSave()) {
                return;
            }
            this.doLoad();
        } else if (string.equals(CMD_FILE_SAVE)) {
            this.doSave();
        } else if (string.equals(CMD_FILE_EXIT)) {
            this.doExit();
        } else if (string.equals(CMD_FILE_SAVEAS)) {
            this.doSaveAs();
        } else if (string.equals(CMD_FILE_EXPORT_TXT)) {
            this.doExportTxt();
        } else if (string.equals(CMD_EDIT_COPY)) {
            this.doEditCopy();
        } else if (string.equals(CMD_EDIT_PASTE)) {
            this.doEditPaste();
        } else if (string.equals(CMD_HELP_ABOUT)) {
            this.doHelpAbout();
        } else if (string.equals(CMD_TOOLS_OPTIONS)) {
            this.doToolsOptions();
        }
    }

    public void doToolsOptions() {
        SettingsDialog settingsDialog = new SettingsDialog((Frame)this, this.cfg);
        settingsDialog.initContents();
        settingsDialog.loadSettings();
        settingsDialog.setVisible(true);
        int n = settingsDialog.getResultCode();
        if (n == 1) {
            String string = this.cfg.getDisplayFormat();
            if (string == null) {
                string = "%g";
            }
            this.fpf.setFormatString(string);
            this.expResultsPanel.repaint();
            this.levelAnalysisYAvgPanel.repaint();
            this.levelAnalysisSigmaPanel.repaint();
        }
    }

    public void doHelpAbout() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.setAboutInfo("admaDIC Calculator Module\nInDXp - Industrial Designed Experiments\nVersion 1.0.0-r16", "Copyright (c) 2005-2022 - admaDIC\nGermany", "For updates or more information \nplease visit http://www.admadic.de/", "This product includes the software JGoodies Forms:\nCopyright (c) 2002-2004 JGoodies Karsten Lentzsch.\nAll rights reserved.");
        aboutDialog.setTitle("About InDXp Module");
        if (this.iconLarge != null) {
            aboutDialog.setLogo(this.iconLarge.getImage());
        }
        aboutDialog.setVisible(true);
    }

    private void doEditCopy() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (!(component instanceof JTable)) {
            return;
        }
        JTable jTable = (JTable)component;
        TabularCopyPasteCore tabularCopyPasteCore = new TabularCopyPasteCore();
        tabularCopyPasteCore.doCopyFrom(jTable);
    }

    private void doEditPaste() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (!(component instanceof JTable)) {
            return;
        }
        JTable jTable = (JTable)component;
        TabularCopyPasteCore tabularCopyPasteCore = new TabularCopyPasteCore();
        tabularCopyPasteCore.doPasteInto(jTable, false);
    }

    protected void doExit() {
        if (this.ideData.isDirty() && !this.checkSave()) {
            return;
        }
        this.dispose();
    }

    private void doLoad() {
        File file = this.ideData.getFileName();
        if ((file = this.getXmlFileNameJFC(false, false, file)) == null) {
            return;
        }
        InDXpDataIO inDXpDataIO = new InDXpDataIO(this.ideData, null);
        try {
            inDXpDataIO.load(file);
            this.ideData.setFileName(file);
            this.setTitleImpl();
        }
        catch (XmlIoError xmlIoError) {
            JOptionPane.showMessageDialog(this, "Error loading the file:\n" + file.toString() + "\nMaybe it is not a valid data file.\nThe internal error message was:\n> " + xmlIoError.getMessage() + " <", "Error loading data file", 0);
            this.ideData.resetData();
        }
        this.ideData.notifyEvent(this, 1);
        this.ideData.notifyEvent(this, 4);
        this.ideData.notifyEvent(this, 16);
        this.ideData.notifyEvent(this, 64);
        this.ideData.notifyEvent(this, 256);
        this.ideData.setDirty(false);
    }

    public boolean checkSave() {
        int n;
        boolean bl = true;
        boolean bl2 = this.isVisible();
        if (!bl2) {
            this.setVisible(true);
        }
        bl = (n = JOptionPane.showConfirmDialog(this, "The data has been modified and not yet saved.\nIf you continue without saving, the changes will be lost.\nDo you wish to save the data?\n(Yes - save, No - don't save and continue, Cancel - abort", "Save data?", 1)) == 0 ? this.doSave() : (n == 1 ? true : (n == 2 ? false : false));
        if (this.isVisible() != bl2) {
            this.setVisible(bl2);
        }
        return bl;
    }

    private boolean doSave() {
        File file = this.ideData.getFileName();
        if (file == null) {
            file = this.getXmlFileNameJFC(true, true, null);
        }
        if (file == null) {
            return false;
        }
        this.doSaveImpl(file);
        return true;
    }

    private boolean doSaveAs() {
        File file = this.ideData.getFileName();
        if ((file = this.getXmlFileNameJFC(true, true, file)) == null) {
            return false;
        }
        this.doSaveImpl(file);
        return true;
    }

    private boolean doExportTxt() {
        File file = this.ideData.getFileName();
        file = new File(file.toString() + "-export.txt");
        if ((file = this.getTxtFileNameJFC(true, true, file)) == null) {
            return false;
        }
        this.doExportImpl(file);
        return true;
    }

    private void doExportImpl(File file) {
        Locale locale = null;
        if (this.appContext != null && this.appContext.getLocaleManager() != null) {
            locale = this.appContext.getLocaleManager().queryLocale(3);
        }
        InDXpDataIO inDXpDataIO = new InDXpDataIO(this.ideData, locale);
        try {
            inDXpDataIO.exportTxt(file);
        }
        catch (XmlIoError xmlIoError) {
            JOptionPane.showMessageDialog(this, "Error exporting the file:\n" + file.toString() + "\nThe internal error message was:\n> " + xmlIoError.getMessage() + " <", "Error exporting data file", 0);
        }
    }

    private void doSaveImpl(File file) {
        InDXpDataIO inDXpDataIO = new InDXpDataIO(this.ideData, null);
        try {
            inDXpDataIO.save(file);
            this.ideData.setFileName(file);
            this.ideData.setDirty(false);
            this.setTitleImpl();
        }
        catch (XmlIoError xmlIoError) {
            JOptionPane.showMessageDialog(this, "Error saving the file:\n" + file.toString() + "\nThe internal error message was:\n> " + xmlIoError.getMessage() + " <", "Error saving data file", 0);
        }
    }

    protected File getTxtFileNameJFC(boolean bl, boolean bl2, File file) {
        class TextFilter
        extends FileFilter {
            TextFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                if (string != null) {
                    boolean bl = string.equals("txt");
                    return bl;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Text Files (*.txt)";
            }
        }
        return this.getFileNameJFC(bl, bl2, file, new TextFilter());
    }

    protected File getXmlFileNameJFC(boolean bl, boolean bl2, File file) {
        class XMLFilter
        extends FileFilter {
            XMLFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                if (string != null) {
                    boolean bl = string.equals("xml");
                    return bl;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "XML Files (*.xml)";
            }
        }
        return this.getFileNameJFC(bl, bl2, file, new XMLFilter());
    }

    protected File getFileNameJFC(boolean bl, boolean bl2, File file, FileFilter fileFilter) {
        File file2 = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setFileHidingEnabled(false);
        if (file != null) {
            jFileChooser.setSelectedFile(file);
        }
        block5: while (true) {
            int n = bl ? jFileChooser.showSaveDialog(this) : jFileChooser.showOpenDialog(this);
            switch (n) {
                case 0: {
                    file2 = jFileChooser.getSelectedFile();
                    if (bl2 && file2.exists()) {
                        int n2 = JOptionPane.showConfirmDialog(this, "The file " + file2.toString() + " already exist.\nOverwrite?", "File exists", 1);
                        if (n2 == 0) {
                            return file2;
                        }
                        if (n2 == 1) continue block5;
                        return null;
                    }
                    return file2;
                }
                case 1: {
                    return null;
                }
                case -1: {
                    return null;
                }
            }
        }
    }

    private void setTitleImpl() {
        Object object = this.title;
        object = this.ideData != null && this.ideData.getFileName() != null ? (String)object + " - " + this.ideData.getFileName().getPath() : (String)object + " - untitled";
        this.setTitle((String)object);
    }

    public InDXpData getData() {
        return this.ideData;
    }
}

