/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.indxp.core.DataEvent;
import de.admadic.calculator.modules.indxp.core.DataEventDispatcher;
import de.admadic.calculator.modules.indxp.core.DataEventListener;
import de.admadic.calculator.modules.indxp.core.DataEventServer;
import de.admadic.calculator.modules.indxp.core.DataItemStatus;
import de.admadic.calculator.modules.indxp.core.Factor;
import de.admadic.calculator.modules.indxp.core.FactorInteraction;
import de.admadic.calculator.modules.indxp.core.FactorInteractionBuilder;
import de.admadic.calculator.modules.indxp.core.FactorInteractionsTableModel;
import de.admadic.calculator.modules.indxp.ui.DataPanel;
import de.admadic.calculator.modules.indxp.ui.NumberInputDialog;
import de.admadic.calculator.modules.indxp.ui.NumberInputSet;
import de.admadic.calculator.modules.indxp.ui.NumberInputValidator;
import de.admadic.ui.util.VetoableToggleButtonModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableColumnModel;

public class FactorInteractionsPanel
extends DataPanel
implements ActionListener,
DataEventListener {
    JTable tableFactorInteractions;
    JScrollPane scrollFactorInteractions;
    FactorInteractionsTableModel tableModelFactorInteractions;
    JPanel panelButtons;
    JButton btnCreate;
    JButton btnCreateRg;
    JButton btnAlias;
    JButton btnDeAlias;
    JButton btnRemove;
    JButton btnUp;
    JButton btnDown;
    JToggleButton btnLock;
    static final String CMD_GEN_FU_FA = "fi.genfufa";
    static final String CMD_GEN_FA_RG = "fi.genfarg";
    static final String CMD_ALIAS = "fi.alias";
    static final String CMD_DEALIAS = "fi.dealias";
    static final String CMD_REMOVE = "fi.remove";
    static final String CMD_UP = "fi.up";
    static final String CMD_DOWN = "fi.down";
    static final String CMD_LOCK = "fi.lock";
    ArrayList<FactorInteraction> factorInteractionsLink;
    ArrayList<Factor> factorsLink;
    FactorInteractionBuilder factorInteractionBuilder;
    private static final long serialVersionUID = 1L;

    protected void initContents(boolean bl) {
        FormLayout formLayout = bl ? new FormLayout("0px, p:grow, 5px, p, 12px", "0px, p:grow, 0px") : new FormLayout("12px, p:grow, 5px, p, 12px", "12px, p:grow, 12px");
        this.setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.tableModelFactorInteractions = new FactorInteractionsTableModel();
        this.tableFactorInteractions = new JTable();
        this.tableFactorInteractions.setModel(this.tableModelFactorInteractions);
        this.scrollFactorInteractions = new JScrollPane();
        this.add((Component)this.scrollFactorInteractions, cellConstraints.xy(2, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.scrollFactorInteractions.setViewportView(this.tableFactorInteractions);
        this.scrollFactorInteractions.setHorizontalScrollBarPolicy(32);
        this.scrollFactorInteractions.setVerticalScrollBarPolicy(22);
        this.tableFactorInteractions.setPreferredScrollableViewportSize(new Dimension(300, 75));
        TableColumnModel tableColumnModel = this.tableFactorInteractions.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(50);
        tableColumnModel.getColumn(1).setPreferredWidth(30);
        tableColumnModel.getColumn(2).setPreferredWidth(170);
        this.panelButtons = new JPanel();
        this.add((Component)this.panelButtons, cellConstraints.xy(4, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        FormLayout formLayout2 = new FormLayout("0px, p, 0px", "0px, p, 5px, p, 5px, p, 5px, p, 5px, p, 5px, p, 5px, p, 5px, p, 0px");
        this.panelButtons.setLayout(formLayout2);
        CellConstraints cellConstraints2 = new CellConstraints();
        this.btnCreate = new JButton("Create");
        this.btnCreate.setActionCommand(CMD_GEN_FU_FA);
        this.btnCreate.addActionListener(this);
        this.btnCreateRg = new JButton("Create...");
        this.btnCreateRg.setActionCommand(CMD_GEN_FA_RG);
        this.btnCreateRg.addActionListener(this);
        this.btnAlias = new JButton("Alias");
        this.btnAlias.setActionCommand(CMD_ALIAS);
        this.btnAlias.addActionListener(this);
        this.btnDeAlias = new JButton("Dealias");
        this.btnDeAlias.setActionCommand(CMD_DEALIAS);
        this.btnDeAlias.addActionListener(this);
        this.btnRemove = new JButton("Del");
        this.btnRemove.setActionCommand(CMD_REMOVE);
        this.btnRemove.addActionListener(this);
        this.btnUp = new JButton("Up");
        this.btnUp.setActionCommand(CMD_UP);
        this.btnUp.addActionListener(this);
        this.btnDown = new JButton("Down");
        this.btnDown.setActionCommand(CMD_DOWN);
        this.btnDown.addActionListener(this);
        this.btnLock = new JToggleButton("Lock");
        this.btnLock.setActionCommand(CMD_LOCK);
        VetoableToggleButtonModel vetoableToggleButtonModel = new VetoableToggleButtonModel();
        vetoableToggleButtonModel.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                if (!string.equals("selected")) {
                    return;
                }
                if (propertyChangeEvent.getSource() != FactorInteractionsPanel.this.btnLock.getModel()) {
                    return;
                }
                Boolean bl = (Boolean)propertyChangeEvent.getOldValue();
                Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                if (!FactorInteractionsPanel.this.allowLockOp(bl, bl2)) {
                    throw new PropertyVetoException(string, propertyChangeEvent);
                }
            }
        });
        this.btnLock.setModel(vetoableToggleButtonModel);
        this.btnLock.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                FactorInteractionsPanel.this.doLock(bl);
            }
        });
        this.panelButtons.add((Component)this.btnCreate, cellConstraints2.xy(2, 2));
        this.panelButtons.add((Component)this.btnCreateRg, cellConstraints2.xy(2, 4));
        this.panelButtons.add((Component)this.btnAlias, cellConstraints2.xy(2, 6));
        this.panelButtons.add((Component)this.btnDeAlias, cellConstraints2.xy(2, 8));
        this.panelButtons.add((Component)this.btnRemove, cellConstraints2.xy(2, 10));
        this.panelButtons.add((Component)this.btnUp, cellConstraints2.xy(2, 12));
        this.panelButtons.add((Component)this.btnDown, cellConstraints2.xy(2, 14));
        this.panelButtons.add((Component)this.btnLock, cellConstraints2.xy(2, 16));
    }

    public FactorInteractionsPanel() {
        this.initContents(false);
    }

    public FactorInteractionsPanel(boolean bl) {
        this.initContents(bl);
    }

    public void linkData(ArrayList<FactorInteraction> arrayList, ArrayList<Factor> arrayList2) {
        this.factorInteractionsLink = arrayList;
        this.factorsLink = arrayList2;
        this.tableModelFactorInteractions.setData(arrayList);
    }

    @Override
    public void setDataEventDispatcher(DataEventDispatcher dataEventDispatcher) {
        super.setDataEventDispatcher(dataEventDispatcher);
        this.tableModelFactorInteractions.setDataEventDispatcher(dataEventDispatcher);
    }

    @Override
    public void setDataEventServer(DataEventServer dataEventServer) {
        if (this.dataEventServer != null) {
            this.dataEventServer.removeDataListener(this.tableModelFactorInteractions);
            this.dataEventServer.removeDataListener(this);
        }
        super.setDataEventServer(dataEventServer);
        if (this.dataEventServer != null) {
            this.dataEventServer.addDataListener(this.tableModelFactorInteractions);
            this.dataEventServer.addDataListener(this);
        }
    }

    @Override
    public void dataEventSignalled(DataEvent dataEvent) {
        if ((dataEvent.getMask() & 4) != 0 && this.getDataItemStatusServer() != null) {
            DataItemStatus dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(1);
            this.btnLock.setSelected(dataItemStatus.isLocked());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_GEN_FU_FA)) {
            this.doCreate();
        } else if (string.equals(CMD_GEN_FA_RG)) {
            this.doCreateRg();
        } else if (string.equals(CMD_ALIAS)) {
            this.doAlias();
        } else if (string.equals(CMD_DEALIAS)) {
            this.doDeAlias();
        } else if (string.equals(CMD_REMOVE)) {
            this.doRemove();
        } else if (string.equals(CMD_UP)) {
            this.doUp();
        } else if (string.equals(CMD_DOWN)) {
            this.doDown();
        }
    }

    private void doCreate() {
        this.factorInteractionBuilder.createFullFactorialInteractions();
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 8);
        }
    }

    private void doCreateRg() {
        NumberInputSet[] numberInputSetArray = new NumberInputSet[]{new NumberInputSet("Minimum length:", "1.." + this.factorsLink.size(), 1, 1, this.factorsLink.size(), 1), new NumberInputSet("Maximum length:", "1.." + this.factorsLink.size(), this.factorsLink.size(), 1, this.factorsLink.size(), 1)};
        NumberInputDialog numberInputDialog = new NumberInputDialog("Please enter range of length for the factor interactions\nto generate.", numberInputSetArray);
        numberInputDialog.setValidator(new NumberInputValidator(){

            @Override
            public boolean validate(NumberInputSet[] numberInputSetArray) {
                if (numberInputSetArray[0].getValue() > numberInputSetArray[1].getValue()) {
                    JOptionPane.showMessageDialog(null, "Minimum length must be smaller than maximum length.", "Invalid data", 0);
                    return false;
                }
                return true;
            }
        });
        numberInputDialog.setVisible(true);
        int n = numberInputDialog.getResultCode();
        if (n != 1) {
            return;
        }
        int n2 = numberInputSetArray[0].getValue();
        int n3 = numberInputSetArray[1].getValue();
        this.factorInteractionBuilder.createFactorialInteractions(n2, n3);
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 8);
        }
    }

    private String getNextFactorName(String string) {
        Object object = string.substring(1);
        String string2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int n = string2.indexOf(string.charAt(0));
        object = n < 0 ? "A" + (String)object : (n >= string2.length() ? "A1" + (String)object : string2.charAt(n + 1) + (String)object);
        return object;
    }

    private void doAlias() {
        int[] nArray = this.tableFactorInteractions.getSelectedRows();
        if (nArray.length < 1) {
            JOptionPane.showMessageDialog(null, "No factor interaction selected.\nYou must select a factor interaction which shall be aliased.", "No factor interaction selected", 0);
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, "Do you want to alias the " + nArray.length + " selected factor interactions?", "Confirm aliasing of factor interaction", 0);
        if (n != 0) {
            return;
        }
        if (this.factorsLink.size() < 1) {
            JOptionPane.showMessageDialog(null, "Factor list is empty.\nPlease check your data.", "Factor list is empty", 0);
            return;
        }
        String string = null;
        for (Factor object : this.factorsLink) {
            if (string == null) {
                string = object.getName();
            }
            if (object.getName().compareTo(string) <= 0) continue;
            string = object.getName();
        }
        Object object = string;
        for (int n2 : nArray) {
            FactorInteraction factorInteraction = this.factorInteractionsLink.get(n2);
            if (factorInteraction.getFactors().size() == 1) {
                return;
            }
            object = this.getNextFactorName((String)object);
            factorInteraction.setAliased(true, (String)object);
        }
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 8);
        }
    }

    private void doDeAlias() {
        int[] nArray = this.tableFactorInteractions.getSelectedRows();
        if (nArray.length < 1) {
            JOptionPane.showMessageDialog(null, "No factor interaction selected.\nYou must select a factor interaction which shall be de-aliased.", "No factor interaction selected", 0);
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, "Do you want to de-alias the " + nArray.length + " selected factor interactions?", "Confirm de-aliasing of factor interaction", 0);
        if (n != 0) {
            return;
        }
        for (int n2 : nArray) {
            FactorInteraction factorInteraction = this.factorInteractionsLink.get(n2);
            factorInteraction.setAliased(false, null);
        }
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 8);
        }
    }

    private void doRemove() {
        int[] nArray = this.tableFactorInteractions.getSelectedRows();
        if (nArray.length < 1) {
            JOptionPane.showMessageDialog(null, "No factor interaction selected.\nYou must select a factor interaction which shall be removed.", "No factor interaction selected", 0);
            return;
        }
        int n = JOptionPane.showConfirmDialog(null, "Do you want to delete the " + nArray.length + " selected factor interactions?", "Confirm removal of factor interaction", 0);
        if (n != 0) {
            return;
        }
        Vector<FactorInteraction> vector = new Vector<FactorInteraction>();
        for (int n2 : nArray) {
            vector.add(this.factorInteractionsLink.get(n2));
        }
        this.factorInteractionsLink.removeAll(vector);
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 8);
        }
    }

    private void doUp() {
        int n = this.tableFactorInteractions.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (n < 1) {
            return;
        }
        Collections.swap(this.factorInteractionsLink, n, n - 1);
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 8);
        }
        this.tableFactorInteractions.setRowSelectionInterval(n - 1, n - 1);
    }

    private void doDown() {
        int n = this.tableFactorInteractions.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (n >= this.factorInteractionsLink.size() - 1) {
            return;
        }
        Collections.swap(this.factorInteractionsLink, n, n + 1);
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 8);
        }
        this.tableFactorInteractions.setRowSelectionInterval(n + 1, n + 1);
    }

    protected void doLock(boolean bl) {
        DataItemStatus dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(1);
        DataPanel.enableComponents((Container)this.panelButtons, !bl, this.btnLock);
        this.tableModelFactorInteractions.setLocked(bl);
        if (bl) {
            dataItemStatus.lock(3);
        } else {
            dataItemStatus.unlock(3);
        }
    }

    protected boolean allowLockOp(boolean bl, boolean bl2) {
        int n;
        DataItemStatus dataItemStatus;
        return this.getDataItemStatusServer() == null || !(dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(1)).isLocked() || !bl || bl2 || (n = JOptionPane.showConfirmDialog(null, "Are you sure, that you want to unlock the data?\nIf you unlock, the data may be changed which may\ninfluence subsequent calculations.\nThe results of these calculations may then be invalid.", "Confirm data unlock", 0)) != 1;
    }

    public void setFactorInteractionBuilder(FactorInteractionBuilder factorInteractionBuilder) {
        this.factorInteractionBuilder = factorInteractionBuilder;
    }

    @Override
    public void updateLockStatus() {
        if (this.getDataItemStatusServer() != null) {
            DataItemStatus dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(1);
            this.btnLock.setSelected(dataItemStatus.isLocked());
        }
    }
}

