/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.modules.indxp.core.DataEvent;
import de.admadic.calculator.modules.indxp.core.DataEventDispatcher;
import de.admadic.calculator.modules.indxp.core.DataEventListener;
import de.admadic.calculator.modules.indxp.core.DataEventServer;
import de.admadic.calculator.modules.indxp.core.DataItemStatus;
import de.admadic.calculator.modules.indxp.core.ExpResults;
import de.admadic.calculator.modules.indxp.core.ExpResultsTableModel;
import de.admadic.calculator.modules.indxp.core.Run;
import de.admadic.calculator.modules.indxp.ui.DataPanel;
import de.admadic.calculator.modules.indxp.ui.ExpResultsCellRenderer;
import de.admadic.calculator.modules.indxp.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.indxp.ui.GradientCellRenderer;
import de.admadic.ui.util.ColorGradient;
import de.admadic.ui.util.VetoableToggleButtonModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class ExpResultsPanel
extends DataPanel
implements ActionListener,
TableColumnModelListener,
DataEventListener {
    private static final long serialVersionUID = 1L;
    JTable tableExpResults;
    JScrollPane scrollExpResults;
    ExpResultsTableModel tableModelExpResults;
    FloatingPointFormatter fpf;
    JPanel panelButtons;
    JButton btnCreate;
    JButton btnRemove;
    JButton btnReset;
    JToggleButton btnLock;
    JButton btnCalculate;
    JToggleButton btnColorize;
    static final String CMD_CREATE = "expres.create";
    static final String CMD_RESET = "expres.reset";
    static final String CMD_REMOVE = "expres.remove";
    static final String CMD_LOCK = "expres.lock";
    static final String CMD_CALCULATE = "expres.calculate";
    static final String CMD_COLORIZE = "expres.colorize";
    ExpResultsCellRenderer cellRendererStat;
    ArrayList<ExpResults> expResultsLink;
    ArrayList<Run> runsLink;

    public ExpResultsPanel(FloatingPointFormatter floatingPointFormatter) {
        this.setFloatingPointFormatter(floatingPointFormatter);
        this.initContents(false);
    }

    public ExpResultsPanel(boolean bl) {
        this.initContents(bl);
    }

    private void initContents(boolean bl) {
        FormLayout formLayout = bl ? new FormLayout("0px, p:grow, 5px, p, 0px", "0px, p:grow, 0px") : new FormLayout("12px, p:grow, 5px, p, 12px", "12px, p:grow, 12px");
        this.setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.tableModelExpResults = new ExpResultsTableModel();
        this.tableExpResults = new JTable();
        this.tableExpResults.setModel(this.tableModelExpResults);
        this.tableExpResults.getColumnModel().addColumnModelListener(this);
        this.scrollExpResults = new JScrollPane();
        this.add((Component)this.scrollExpResults, cellConstraints.xy(2, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.scrollExpResults.setViewportView(this.tableExpResults);
        this.scrollExpResults.setHorizontalScrollBarPolicy(32);
        this.scrollExpResults.setVerticalScrollBarPolicy(22);
        this.tableExpResults.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.tableExpResults.setAutoResizeMode(0);
        this.cellRendererStat = new ExpResultsCellRenderer(ColorGradient.JET(), GradientCellRenderer.BORDER_LEFT, 1);
        this.cellRendererStat.setFloatingPointFormatter(this.fpf);
        this.tableExpResults.setDefaultRenderer(Double.class, this.cellRendererStat);
        this.panelButtons = new JPanel();
        this.add((Component)this.panelButtons, cellConstraints.xy(4, 2, CellConstraints.DEFAULT, CellConstraints.FILL));
        FormLayout formLayout2 = new FormLayout("p", "p, 5px, p, 5px, p, 5px, p, 5px, p, 5px, p");
        this.panelButtons.setLayout(formLayout2);
        CellConstraints cellConstraints2 = new CellConstraints();
        this.btnCreate = new JButton("Create");
        this.btnCreate.setActionCommand(CMD_CREATE);
        this.btnCreate.addActionListener(this);
        this.btnRemove = new JButton("Remove");
        this.btnRemove.setActionCommand(CMD_REMOVE);
        this.btnRemove.addActionListener(this);
        this.btnReset = new JButton("Reset...");
        this.btnReset.setActionCommand(CMD_RESET);
        this.btnReset.addActionListener(this);
        this.btnLock = new JToggleButton("Lock");
        this.btnLock.setActionCommand(CMD_LOCK);
        this.btnLock.addActionListener(this);
        VetoableToggleButtonModel vetoableToggleButtonModel = new VetoableToggleButtonModel();
        vetoableToggleButtonModel.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                if (!string.equals("selected")) {
                    return;
                }
                if (propertyChangeEvent.getSource() != ExpResultsPanel.this.btnLock.getModel()) {
                    return;
                }
                Boolean bl = (Boolean)propertyChangeEvent.getOldValue();
                Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                if (!ExpResultsPanel.this.allowLockOp(bl, bl2)) {
                    throw new PropertyVetoException(string, propertyChangeEvent);
                }
            }
        });
        this.btnLock.setModel(vetoableToggleButtonModel);
        this.btnLock.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ExpResultsPanel.this.doLock(true);
                } else {
                    ExpResultsPanel.this.doLock(false);
                }
            }
        });
        this.btnCalculate = new JButton("Calculate");
        this.btnCalculate.setActionCommand(CMD_CALCULATE);
        this.btnCalculate.addActionListener(this);
        this.btnColorize = new JToggleButton("Colorize");
        this.btnColorize.setActionCommand(CMD_COLORIZE);
        this.btnColorize.addActionListener(this);
        this.btnColorize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ExpResultsPanel.this.doColorize(true);
                } else {
                    ExpResultsPanel.this.doColorize(false);
                }
            }
        });
        this.panelButtons.add((Component)this.btnCreate, cellConstraints2.xy(1, 1));
        this.panelButtons.add((Component)this.btnRemove, cellConstraints2.xy(1, 3));
        this.panelButtons.add((Component)this.btnReset, cellConstraints2.xy(1, 5));
        this.panelButtons.add((Component)this.btnLock, cellConstraints2.xy(1, 7));
        this.panelButtons.add((Component)this.btnCalculate, cellConstraints2.xy(1, 9));
        this.panelButtons.add((Component)this.btnColorize, cellConstraints2.xy(1, 11));
    }

    public void linkData(ArrayList<ExpResults> arrayList, ArrayList<Run> arrayList2) {
        this.expResultsLink = arrayList;
        this.runsLink = arrayList2;
        this.tableModelExpResults.setData(this.expResultsLink);
    }

    @Override
    public void setDataEventDispatcher(DataEventDispatcher dataEventDispatcher) {
        super.setDataEventDispatcher(dataEventDispatcher);
        this.tableModelExpResults.setDataEventDispatcher(dataEventDispatcher);
    }

    @Override
    public void setDataEventServer(DataEventServer dataEventServer) {
        if (this.dataEventServer != null) {
            this.dataEventServer.removeDataListener(this.tableModelExpResults);
            this.dataEventServer.removeDataListener(this);
        }
        super.setDataEventServer(dataEventServer);
        if (this.dataEventServer != null) {
            this.dataEventServer.addDataListener(this.tableModelExpResults);
            this.dataEventServer.addDataListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_CREATE)) {
            this.doCreate();
        } else if (string.equals(CMD_RESET)) {
            this.doReset();
        } else if (string.equals(CMD_REMOVE)) {
            this.doRemove();
        } else if (!string.equals(CMD_LOCK) && string.equals(CMD_CALCULATE)) {
            this.doCalculate();
        }
    }

    protected void doLock(boolean bl) {
        this.tableModelExpResults.setLocked(bl);
        DataPanel.enableComponents((Container)this.panelButtons, !bl, new Component[]{this.btnLock, this.btnColorize});
        if (this.getDataItemStatusServer() != null) {
            DataItemStatus dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(3);
            if (bl) {
                dataItemStatus.lock(3);
            } else {
                dataItemStatus.unlock(3);
            }
        }
    }

    protected boolean allowLockOp(boolean bl, boolean bl2) {
        int n;
        DataItemStatus dataItemStatus;
        return this.getDataItemStatusServer() == null || !(dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(3)).isLocked() || !bl || bl2 || (n = JOptionPane.showConfirmDialog(null, "Are you sure, that you want to unlock the data?\nIf you unlock, the data may be changed which may\ninfluence subsequent calculations.\nThe results of these calculations may then be invalid.", "Confirm data unlock", 0)) != 1;
    }

    protected void doColorize(boolean bl) {
        this.cellRendererStat.setOn(bl);
        this.updateRanges();
    }

    private void doCreate() {
        int n;
        if (this.expResultsLink.size() > 0 && (n = JOptionPane.showConfirmDialog(null, "There are already existing replicates which would be removed.\nDo you want to create new replicates?", "Confirm creation of new replicates", 0)) != 0) {
            return;
        }
        this.expResultsLink.clear();
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 1024);
        }
        n = -1;
        String string = "1";
        while (true) {
            String string2;
            if ((string2 = JOptionPane.showInputDialog(null, "Please enter the number of replicates to support (1..100)", string)) == null) {
                return;
            }
            n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string = string2;
                JOptionPane.showMessageDialog(null, "Number parsing error.\nPlease correct the input.", "Invalid number format", 0);
                continue;
            }
            if (n < 1) {
                JOptionPane.showMessageDialog(null, "Number out of range.\nThe number of runs must 1 or greater.", "Invalid number range", 0);
                string = string2;
                continue;
            }
            if (n <= 100) break;
            JOptionPane.showMessageDialog(null, "Number out of range.\nThe number of runs must not be larger than 100.", "Invalid number range", 0);
            string = string2;
        }
        for (int i = 0; i < this.runsLink.size(); ++i) {
            ExpResults expResults = new ExpResults(n);
            this.expResultsLink.add(expResults);
        }
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 64);
        }
    }

    private void doReset() {
        int n = JOptionPane.showConfirmDialog(null, "Please confirm that the all result sets shall be reset.\nAll entered values will be lost.\nDo you want to reset them?", "Confirm reset of all result sets", 0);
        if (n != 0) {
            return;
        }
        for (ExpResults expResults : this.expResultsLink) {
            expResults.resetData();
        }
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 1152);
        }
    }

    private void doRemove() {
        int n = JOptionPane.showConfirmDialog(null, "Please confirm that the all result sets shall be deleted.\nDo you want to delete them?", "Confirm deletion of all result sets", 0);
        if (n != 0) {
            return;
        }
        this.expResultsLink.clear();
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 1088);
        }
    }

    private void doCalculate() {
        for (ExpResults expResults : this.expResultsLink) {
            expResults.calculate();
        }
        this.updateRanges();
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 1152);
        }
    }

    private Double[] getRangeYAvg() {
        Double[] doubleArray = new Double[2];
        for (ExpResults expResults : this.expResultsLink) {
            Double d = expResults.getYAvg();
            if (doubleArray[0] == null || doubleArray[0] > d) {
                doubleArray[0] = d;
            }
            if (doubleArray[1] != null && !(doubleArray[1] < d)) continue;
            doubleArray[1] = d;
        }
        return doubleArray;
    }

    private Double[] getRangeSigma() {
        Double[] doubleArray = new Double[2];
        for (ExpResults expResults : this.expResultsLink) {
            Double d = expResults.getSigma();
            if (doubleArray[0] == null || doubleArray[0] > d) {
                doubleArray[0] = d;
            }
            if (doubleArray[1] != null && !(doubleArray[1] < d)) continue;
            doubleArray[1] = d;
        }
        return doubleArray;
    }

    protected void updateRanges() {
        if (this.expResultsLink.size() < 1) {
            return;
        }
        ExpResults expResults = this.expResultsLink.get(0);
        this.cellRendererStat.clearRanges();
        Double[] doubleArray = this.getRangeYAvg();
        this.cellRendererStat.addCellRange((Integer)expResults.getReplicateCount(), doubleArray[0], doubleArray[1]);
        doubleArray = this.getRangeSigma();
        this.cellRendererStat.addCellRange((Integer)(expResults.getReplicateCount() + 1), doubleArray[0], doubleArray[1]);
        this.tableModelExpResults.fireTableDataChanged();
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        int n = tableColumnModelEvent.getToIndex();
        TableColumnModel tableColumnModel = this.tableExpResults.getColumnModel();
        tableColumnModel.getColumn(n).setPreferredWidth(80);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void dataEventSignalled(DataEvent dataEvent) {
        if (dataEvent.getSource() == this) {
            return;
        }
        if ((dataEvent.getMask() & 0x40) != 0 && this.getDataItemStatusServer() != null) {
            DataItemStatus dataItemStatus = this.getDataItemStatusServer().getDataItemStatus(3);
            this.btnLock.setSelected(dataItemStatus.isLocked());
        }
    }

    public void setFloatingPointFormatter(FloatingPointFormatter floatingPointFormatter) {
        this.fpf = floatingPointFormatter;
    }
}

