/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.core;

import de.admadic.calculator.modules.indxp.core.DataEvent;
import de.admadic.calculator.modules.indxp.core.DataEventDispatcher;
import de.admadic.calculator.modules.indxp.core.DataEventListener;
import de.admadic.calculator.modules.indxp.core.DataEventServer;
import de.admadic.calculator.modules.indxp.core.Factor;
import de.admadic.calculator.modules.indxp.core.FactorInteraction;
import de.admadic.calculator.modules.indxp.core.Run;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class RunsTableModel
extends AbstractTableModel
implements DataEventListener {
    private static final long serialVersionUID = 1L;
    ArrayList<Run> runs;
    ArrayList<FactorInteraction> factorInteractions;
    DataEventDispatcher dataEventDispatcher;
    DataEventServer dataEventServer;
    boolean locked;

    public void setData(ArrayList<Run> arrayList, ArrayList<FactorInteraction> arrayList2) {
        this.runs = arrayList;
        this.factorInteractions = arrayList2;
    }

    public void setDataEventDispatcher(DataEventDispatcher dataEventDispatcher) {
        this.dataEventDispatcher = dataEventDispatcher;
    }

    public void setDataEventServer(DataEventServer dataEventServer) {
        this.dataEventServer = dataEventServer;
    }

    @Override
    public int getRowCount() {
        if (this.runs != null) {
            return this.runs.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this.factorInteractions != null) {
            return 1 + this.factorInteractions.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.runs == null || this.factorInteractions == null) {
            return null;
        }
        if (n2 == 0) {
            return this.runs.get(n).getId();
        }
        FactorInteraction factorInteraction = this.factorInteractions.get(n2 - 1);
        Integer n3 = this.runs.get(n).getFiLevel(factorInteraction);
        return n3;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.runs == null || this.factorInteractions == null) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        FactorInteraction factorInteraction = this.factorInteractions.get(n2 - 1);
        Factor factor = factorInteraction.getFactors().firstElement();
        Integer n3 = (Integer)object;
        Run run = this.runs.get(n);
        run.setLevel(factor, n3);
        run.updateFactorInteractionLevels();
        this.fireTableRowsUpdated(n, n);
        if (this.dataEventDispatcher != null) {
            this.dataEventDispatcher.notifyEvent(this, 1024);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n < 1) {
            return String.class;
        }
        return Integer.class;
    }

    @Override
    public String getColumnName(int n) {
        if (this.factorInteractions == null) {
            return null;
        }
        if (n < 0 || n >= this.factorInteractions.size() + 1) {
            return null;
        }
        if (n == 0) {
            return "Run";
        }
        FactorInteraction factorInteraction = this.factorInteractions.get(n - 1);
        return factorInteraction.getDisplay();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.runs == null || this.factorInteractions == null) {
            return false;
        }
        if (this.isLocked()) {
            return false;
        }
        if (n2 == 0) {
            return false;
        }
        FactorInteraction factorInteraction = this.factorInteractions.get(n2 - 1);
        int n3 = factorInteraction.getFactors().size();
        return n3 == 1;
    }

    @Override
    public void dataEventSignalled(DataEvent dataEvent) {
        if (dataEvent.getSource() == this) {
            return;
        }
        if ((dataEvent.getMask() & 0x20) != 0) {
            this.fireTableDataChanged();
        }
        if ((dataEvent.getMask() & 0x10) != 0) {
            this.fireTableStructureChanged();
        }
        if ((dataEvent.getMask() & 8) != 0) {
            this.fireTableStructureChanged();
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
        this.fireTableDataChanged();
    }
}

