/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.core;

import de.admadic.calculator.modules.indxp.core.DataEvent;
import de.admadic.calculator.modules.indxp.core.DataEventDispatcher;
import de.admadic.calculator.modules.indxp.core.DataEventListener;
import de.admadic.calculator.modules.indxp.core.DataEventServer;
import de.admadic.calculator.modules.indxp.core.FactorInteraction;
import de.admadic.calculator.modules.indxp.core.LevelAnalysis;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class LevelAnalysisTableModel
extends AbstractTableModel
implements DataEventListener {
    private static final long serialVersionUID = 1L;
    ArrayList<FactorInteraction> factorInteractions;
    LevelAnalysis levelAnalysis;
    DataEventDispatcher dataEventDispatcher;
    DataEventServer dataEventServer;

    public void setData(ArrayList<FactorInteraction> arrayList, LevelAnalysis levelAnalysis) {
        this.factorInteractions = arrayList;
        this.levelAnalysis = levelAnalysis;
    }

    public void setDataEventDispatcher(DataEventDispatcher dataEventDispatcher) {
        this.dataEventDispatcher = dataEventDispatcher;
    }

    public void setDataEventServer(DataEventServer dataEventServer) {
        this.dataEventServer = dataEventServer;
    }

    @Override
    public int getRowCount() {
        return 3;
    }

    @Override
    public int getColumnCount() {
        if (this.factorInteractions != null && this.factorInteractions.size() > 0) {
            return 1 + this.factorInteractions.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.factorInteractions == null) {
            return null;
        }
        if (this.factorInteractions.size() < 1) {
            return null;
        }
        if (n2 == 0) {
            switch (n) {
                case 0: {
                    return this.levelAnalysis.getName() + "@+1";
                }
                case 1: {
                    return this.levelAnalysis.getName() + "@-1";
                }
                case 2: {
                    return "Delta";
                }
            }
            return null;
        }
        FactorInteraction factorInteraction = this.factorInteractions.get(n2 - 1);
        switch (n) {
            case 0: {
                return this.levelAnalysis.getHighValue(factorInteraction);
            }
            case 1: {
                return this.levelAnalysis.getLowValue(factorInteraction);
            }
            case 2: {
                return this.levelAnalysis.getDeltaValue(factorInteraction);
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n < 1) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public String getColumnName(int n) {
        if (this.factorInteractions == null) {
            return null;
        }
        if (n < 0 || n >= this.factorInteractions.size() + 1) {
            return null;
        }
        if (n == 0) {
            return "LvAn";
        }
        FactorInteraction factorInteraction = this.factorInteractions.get(n - 1);
        String string = factorInteraction.getDisplay();
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void dataEventSignalled(DataEvent dataEvent) {
        if (dataEvent.getSource() == this) {
            return;
        }
        if ((dataEvent.getMask() & 0x200) != 0) {
            this.fireTableDataChanged();
        }
        if ((dataEvent.getMask() & 0x100) != 0) {
            this.fireTableStructureChanged();
        } else if ((dataEvent.getMask() & 8) != 0) {
            this.fireTableStructureChanged();
        } else if ((dataEvent.getMask() & 4) != 0) {
            this.fireTableStructureChanged();
        }
    }
}

