/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.core;

import de.admadic.calculator.modules.indxp.core.DataItemStatus;
import de.admadic.calculator.modules.indxp.core.ExpResults;
import de.admadic.calculator.modules.indxp.core.Factor;
import de.admadic.calculator.modules.indxp.core.FactorInteraction;
import de.admadic.calculator.modules.indxp.core.InDXpData;
import de.admadic.calculator.modules.indxp.core.LevelAnalysis;
import de.admadic.calculator.modules.indxp.core.Run;
import de.admadic.calculator.modules.indxp.core.XmlIoError;
import de.admadic.util.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParserFactory;
import net.n3.nanoxml.XMLWriter;

public class InDXpDataIO {
    InDXpData data;
    Locale locale;
    Hashtable<Integer, Factor> idToFactor;
    Hashtable<Integer, FactorInteraction> idToFactorInteraction;
    Hashtable<Integer, Integer> idToLevel;
    Hashtable<Integer, Run> idToRun;
    Hashtable<Integer, ExpResults> idToExpResults;
    Hashtable<Factor, Integer> factorToId;
    Hashtable<FactorInteraction, Integer> factorInteractionToId;
    Hashtable<Integer, Integer> levelToId;
    Hashtable<Run, Integer> runToId;
    Hashtable<ExpResults, Integer> expResultsToId;

    public InDXpDataIO(InDXpData inDXpData, Locale locale) {
        this.data = inDXpData;
        this.locale = locale;
    }

    public void load(File file) {
        try {
            String string = file.toString();
            string = FileUtil.fixFileName1(string);
            IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
            IXMLReader iXMLReader = StdXMLReader.fileReader(string);
            iXMLParser.setReader(iXMLReader);
            IXMLElement iXMLElement = (IXMLElement)iXMLParser.parse();
            if (!iXMLElement.getName().equals("indxpdata")) {
                throw new XmlIoError("root is not indxpdata.");
            }
            IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("dataitemstatuslist");
            if (iXMLElement2 == null) {
                throw new XmlIoError("indxpdata.dataitemstatuslist not found.");
            }
            this.readDataItemStatusList(iXMLElement2);
            iXMLElement2 = iXMLElement.getFirstChildNamed("factors");
            if (iXMLElement2 == null) {
                throw new XmlIoError("indxpdata.factors not found.");
            }
            this.readFactors(iXMLElement2);
            iXMLElement2 = iXMLElement.getFirstChildNamed("factorinteractions");
            if (iXMLElement2 == null) {
                throw new XmlIoError("indxpdata.factorinteractions not found.");
            }
            this.readFactorInteractions(iXMLElement2);
            iXMLElement2 = iXMLElement.getFirstChildNamed("levels");
            if (iXMLElement2 == null) {
                throw new XmlIoError("indxpdata.levels not found.");
            }
            this.readLevels(iXMLElement2);
            iXMLElement2 = iXMLElement.getFirstChildNamed("runs");
            if (iXMLElement2 == null) {
                throw new XmlIoError("indxpdata.runs not found.");
            }
            this.readRuns(iXMLElement2);
            iXMLElement2 = iXMLElement.getFirstChildNamed("expresults");
            if (iXMLElement2 == null) {
                throw new XmlIoError("indxpdata.expresults not found.");
            }
            this.readExpResults(iXMLElement2);
            this.readLevelAnalysis(iXMLElement);
        }
        catch (Exception exception) {
            throw new XmlIoError("Load Error: " + exception.getMessage());
        }
    }

    public void save(File file) {
        XMLElement xMLElement = new XMLElement("indxpdata");
        XMLElement xMLElement2 = new XMLElement("dataitemstatuslist");
        this.generateDataItemStatusList(xMLElement2);
        xMLElement.addChild(xMLElement2);
        xMLElement2 = new XMLElement("factors");
        this.generateFactors(xMLElement2);
        xMLElement.addChild(xMLElement2);
        xMLElement2 = new XMLElement("factorinteractions");
        this.generateFactorInteractions(xMLElement2);
        xMLElement.addChild(xMLElement2);
        xMLElement2 = new XMLElement("levels");
        this.generateLevels(xMLElement2);
        xMLElement.addChild(xMLElement2);
        xMLElement2 = new XMLElement("runs");
        this.generateRuns(xMLElement2);
        xMLElement.addChild(xMLElement2);
        xMLElement2 = new XMLElement("expresults");
        this.generateExpResults(xMLElement2);
        xMLElement.addChild(xMLElement2);
        xMLElement2 = new XMLElement("levelanalysis");
        this.generateExpResults(xMLElement2, this.data.getLevelAnalysisYAvg());
        xMLElement.addChild(xMLElement2);
        xMLElement2 = new XMLElement("levelanalysis");
        this.generateExpResults(xMLElement2, this.data.getLevelAnalysisSigma());
        xMLElement.addChild(xMLElement2);
        try {
            FileWriter fileWriter = new FileWriter(file);
            ((Writer)fileWriter).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            XMLElement xMLElement3 = xMLElement;
            XMLWriter xMLWriter = new XMLWriter(fileWriter);
            xMLWriter.write(xMLElement3, true);
        }
        catch (Exception exception) {
            throw new XmlIoError("Save Error: " + exception.getMessage());
        }
    }

    public void exportTxt(File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.exportTxtFactors(bufferedWriter);
            this.exportTxtFactorInteractions(bufferedWriter);
            this.exportTxtRuns(bufferedWriter);
            this.exportTxtExpResults(bufferedWriter);
            this.exportTxtLevelAnalysis(bufferedWriter, this.data.getLevelAnalysisYAvg());
            this.exportTxtLevelAnalysis(bufferedWriter, this.data.getLevelAnalysisSigma());
            bufferedWriter.close();
        }
        catch (Exception exception) {
            throw new XmlIoError("Export Error: " + exception.getMessage());
        }
    }

    private void generateDataItemStatusList(IXMLElement iXMLElement) {
        this.generateDataItemStatusList(iXMLElement, "FACTORS", 0);
        this.generateDataItemStatusList(iXMLElement, "FACTORINTERACTIONS", 1);
        this.generateDataItemStatusList(iXMLElement, "RUNS", 2);
        this.generateDataItemStatusList(iXMLElement, "EXPRESULTS", 3);
    }

    private void generateDataItemStatusList(IXMLElement iXMLElement, String string, int n) {
        String string2;
        XMLElement xMLElement = new XMLElement("dataitemstatus");
        xMLElement.setAttribute("id", string);
        switch (this.data.getDataItemStatus(n).getDataStatus()) {
            case 0: {
                string2 = "UNINITIALIZED";
                break;
            }
            case 1: {
                string2 = "CREATED";
                break;
            }
            case 2: {
                string2 = "FILLEDPARTIALLY";
                break;
            }
            case 3: {
                string2 = "FILLED";
                break;
            }
            default: {
                throw new XmlIoError("Data error in DataItemStatus: unknown dataStatus");
            }
        }
        xMLElement.setAttribute("dataStatus", string2);
        Object object = "";
        if (this.data.getDataItemStatus(n).isDataLocked()) {
            object = (String)object + ",DATA";
        }
        if (this.data.getDataItemStatus(n).isStructureLocked()) {
            object = (String)object + ",STRUCT";
        }
        if (((String)object).startsWith(",")) {
            object = ((String)object).substring(1);
        }
        xMLElement.setAttribute("lockStatus", (String)object);
        iXMLElement.addChild(xMLElement);
    }

    private void generateFactors(IXMLElement iXMLElement) {
        this.factorToId = new Hashtable();
        int n = 0;
        for (int i = 0; i < this.data.getFactorList().size(); ++i) {
            Factor factor = this.data.getFactorList().get(i);
            XMLElement xMLElement = new XMLElement("factor");
            xMLElement.setAttribute("id", String.valueOf(n));
            xMLElement.setAttribute("name", factor.getName());
            xMLElement.setAttribute("entity", factor.getEntity());
            xMLElement.setAttribute("unit", factor.getUnit());
            xMLElement.setAttribute("valueLow", factor.getValueLow());
            xMLElement.setAttribute("valueHigh", factor.getValueHigh());
            iXMLElement.addChild(xMLElement);
            this.factorToId.put(factor, n);
            ++n;
        }
    }

    private void generateFactorInteractions(IXMLElement iXMLElement) {
        this.factorInteractionToId = new Hashtable();
        int n = 0;
        for (int i = 0; i < this.data.getFactorInteractionList().size(); ++i) {
            FactorInteraction factorInteraction = this.data.getFactorInteractionList().get(i);
            XMLElement xMLElement = new XMLElement("factorinteraction");
            xMLElement.setAttribute("id", String.valueOf(n));
            if (factorInteraction.isAliased()) {
                xMLElement.setAttribute("alias", factorInteraction.getAliasName());
            }
            for (int j = 0; j < factorInteraction.getFactors().size(); ++j) {
                Factor factor = factorInteraction.getFactors().get(j);
                XMLElement xMLElement2 = new XMLElement("item");
                xMLElement2.setAttribute("factorId", this.factorToId.get(factor).toString());
                xMLElement.addChild(xMLElement2);
            }
            iXMLElement.addChild(xMLElement);
            this.factorInteractionToId.put(factorInteraction, n);
            ++n;
        }
    }

    private void generateLevels(IXMLElement iXMLElement) {
        this.levelToId = new Hashtable();
        int n = 0;
        XMLElement xMLElement = new XMLElement("level");
        xMLElement.setAttribute("id", String.valueOf(n));
        this.levelToId.put(-1, n);
        xMLElement.setAttribute("name", "low");
        xMLElement.setAttribute("value", "-1");
        iXMLElement.addChild(xMLElement);
        xMLElement = new XMLElement("level");
        xMLElement.setAttribute("id", String.valueOf(++n));
        this.levelToId.put(1, n);
        xMLElement.setAttribute("name", "high");
        xMLElement.setAttribute("value", "+1");
        iXMLElement.addChild(xMLElement);
    }

    private void generateRuns(IXMLElement iXMLElement) {
        this.runToId = new Hashtable();
        int n = 0;
        for (int i = 0; i < this.data.getRunList().size(); ++i) {
            Run run = this.data.getRunList().get(i);
            XMLElement xMLElement = new XMLElement("run");
            xMLElement.setAttribute("id", String.valueOf(n));
            xMLElement.setAttribute("idname", run.getId());
            for (Factor factor : this.data.getFactorList()) {
                XMLElement xMLElement2 = new XMLElement("item");
                Integer n2 = run.getFactorLevel(factor);
                xMLElement2.setAttribute("factorId", this.factorToId.get(factor).toString());
                xMLElement2.setAttribute("levelId", this.levelToId.get(n2).toString());
                xMLElement.addChild(xMLElement2);
            }
            iXMLElement.addChild(xMLElement);
            this.runToId.put(run, n);
            ++n;
        }
    }

    private String Double2String(Double d) {
        if (d == null) {
            return "null";
        }
        return d.toString();
    }

    private void generateExpResults(IXMLElement iXMLElement) {
        this.expResultsToId = new Hashtable();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < this.data.getExpResultsList().size(); ++i) {
            ExpResults expResults = this.data.getExpResultsList().get(i);
            XMLElement xMLElement = new XMLElement("expresult");
            xMLElement.setAttribute("id", String.valueOf(n));
            if (!bl) {
                iXMLElement.setAttribute("replicates", String.valueOf(expResults.getReplicateCount()));
                bl = true;
            }
            Integer n2 = this.runToId.get(this.data.getRunList().get(i));
            xMLElement.setAttribute("runId", n2.toString());
            for (int j = 0; j < expResults.getReplicateCount(); ++j) {
                Double d = expResults.getResult(j);
                XMLElement xMLElement2 = new XMLElement("y");
                xMLElement2.setAttribute("value", this.Double2String(d));
                xMLElement.addChild(xMLElement2);
            }
            XMLElement xMLElement3 = new XMLElement("yavg");
            xMLElement3.setAttribute("value", this.Double2String(expResults.getYAvg()));
            xMLElement.addChild(xMLElement3);
            xMLElement3 = new XMLElement("sigma");
            xMLElement3.setAttribute("value", this.Double2String(expResults.getSigma()));
            xMLElement.addChild(xMLElement3);
            iXMLElement.addChild(xMLElement);
            this.expResultsToId.put(expResults, n);
            ++n;
        }
    }

    private void generateExpResults(IXMLElement iXMLElement, LevelAnalysis levelAnalysis) {
        XMLElement xMLElement;
        FactorInteraction factorInteraction;
        int n;
        iXMLElement.setAttribute("name", levelAnalysis.getName());
        XMLElement xMLElement2 = new XMLElement("resultset");
        xMLElement2.setAttribute("type", "level");
        xMLElement2.setAttribute("levelId", this.levelToId.get(-1).toString());
        for (n = 0; n < this.data.getFactorInteractionList().size(); ++n) {
            factorInteraction = this.data.getFactorInteractionList().get(n);
            xMLElement = new XMLElement("fiitem");
            xMLElement.setAttribute("fiId", this.factorInteractionToId.get(factorInteraction).toString());
            xMLElement.setAttribute("value", this.Double2String(levelAnalysis.getLowValue(factorInteraction)));
            xMLElement2.addChild(xMLElement);
        }
        iXMLElement.addChild(xMLElement2);
        xMLElement2 = new XMLElement("resultset");
        xMLElement2.setAttribute("type", "level");
        xMLElement2.setAttribute("levelId", this.levelToId.get(1).toString());
        for (n = 0; n < this.data.getFactorInteractionList().size(); ++n) {
            factorInteraction = this.data.getFactorInteractionList().get(n);
            xMLElement = new XMLElement("fiitem");
            xMLElement.setAttribute("fiId", this.factorInteractionToId.get(factorInteraction).toString());
            xMLElement.setAttribute("value", this.Double2String(levelAnalysis.getHighValue(factorInteraction)));
            xMLElement2.addChild(xMLElement);
        }
        iXMLElement.addChild(xMLElement2);
        xMLElement2 = new XMLElement("resultset");
        xMLElement2.setAttribute("type", "delta");
        for (n = 0; n < this.data.getFactorInteractionList().size(); ++n) {
            factorInteraction = this.data.getFactorInteractionList().get(n);
            xMLElement = new XMLElement("fiitem");
            xMLElement.setAttribute("fiId", this.factorInteractionToId.get(factorInteraction).toString());
            xMLElement.setAttribute("value", this.Double2String(levelAnalysis.getDeltaValue(factorInteraction)));
            xMLElement2.addChild(xMLElement);
        }
        iXMLElement.addChild(xMLElement2);
    }

    private void readDataItemStatusList(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("dataitemstatus");
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            DataItemStatus dataItemStatus = new DataItemStatus();
            String string = iXMLElement2.getAttribute("dataStatus", "");
            if (string.equals("UNINITIALIZED")) {
                dataItemStatus.setDataStatus(0);
            } else if (string.equals("CREATED")) {
                dataItemStatus.setDataStatus(1);
            } else if (string.equals("FILLEDPARTIALLY")) {
                dataItemStatus.setDataStatus(2);
            } else if (string.equals("FILLED")) {
                dataItemStatus.setDataStatus(3);
            } else if (!string.equals("")) {
                throw new XmlIoError("dataitemstatus:dataStatus invalid.");
            }
            String string2 = iXMLElement2.getAttribute("lockStatus", "");
            String[] stringArray = string2.split(",");
            for (String string3 : stringArray) {
                if (string3.equals("DATA")) {
                    dataItemStatus.lock(2);
                    continue;
                }
                if (string3.equals("STRUCT")) {
                    dataItemStatus.lock(1);
                    continue;
                }
                if (string3.equals("")) continue;
                throw new XmlIoError("dataitemstatus.lockStatus invalid: " + string3);
            }
            String string4 = iXMLElement2.getAttribute("id", null);
            if (string4 == null) {
                throw new XmlIoError("dataitemstatus.id not defined.");
            }
            if (string4.equals("FACTORS")) {
                this.data.setDataItemStatus(0, dataItemStatus);
                continue;
            }
            if (string4.equals("FACTORINTERACTIONS")) {
                this.data.setDataItemStatus(1, dataItemStatus);
                continue;
            }
            if (string4.equals("RUNS")) {
                this.data.setDataItemStatus(2, dataItemStatus);
                continue;
            }
            if (string4.equals("EXPRESULTS")) {
                this.data.setDataItemStatus(3, dataItemStatus);
                continue;
            }
            throw new XmlIoError("dataitemstatus.id invalid.");
        }
    }

    private void readFactors(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("factor");
        this.idToFactor = new Hashtable();
        this.data.getFactorList().clear();
        for (Object e : vector) {
            Integer n;
            IXMLElement iXMLElement2 = (IXMLElement)e;
            Factor factor = new Factor();
            String string = iXMLElement2.getAttribute("id", null);
            if (string == null) {
                throw new XmlIoError("factor.id not found.");
            }
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new XmlIoError("factor.id could not be parsed.");
            }
            this.idToFactor.put(n, factor);
            String string2 = iXMLElement2.getAttribute("name", null);
            if (string2 == null) {
                throw new XmlIoError("factor.name not found.");
            }
            factor.setName(string2);
            string2 = iXMLElement2.getAttribute("entity", null);
            if (string2 == null) {
                throw new XmlIoError("factor.entity not found.");
            }
            factor.setEntity(string2);
            string2 = iXMLElement2.getAttribute("unit", null);
            if (string2 == null) {
                throw new XmlIoError("factor.unit not found.");
            }
            factor.setUnit(string2);
            string2 = iXMLElement2.getAttribute("valueLow", null);
            if (string2 == null) {
                throw new XmlIoError("factor.valueLow not found.");
            }
            factor.setValueLow(string2);
            string2 = iXMLElement2.getAttribute("valueHigh", null);
            if (string2 == null) {
                throw new XmlIoError("factor.valueHigh not found.");
            }
            factor.setValueHigh(string2);
            this.data.getFactorList().add(factor);
        }
    }

    private void readFactorInteractions(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("factorinteraction");
        this.idToFactorInteraction = new Hashtable();
        this.data.getFactorInteractionList().clear();
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            FactorInteraction factorInteraction = new FactorInteraction();
            Integer n = this.parseId(iXMLElement2, "id", "factorinteraction:id");
            this.idToFactorInteraction.put(n, factorInteraction);
            Vector vector2 = iXMLElement2.getChildrenNamed("item");
            for (Object e2 : vector2) {
                IXMLElement iXMLElement3 = (IXMLElement)e2;
                Integer n2 = this.parseId(iXMLElement3, "factorId", "factorinteraction.item:factorId");
                if (!this.idToFactor.containsKey(n2)) {
                    throw new XmlIoError("reference to factorId which does not exist");
                }
                factorInteraction.addFactor(this.idToFactor.get(n2));
            }
            String string = iXMLElement2.getAttribute("alias", null);
            if (string != null) {
                factorInteraction.setAliased(true, string);
            }
            this.data.getFactorInteractionList().add(factorInteraction);
        }
    }

    private void readLevels(IXMLElement iXMLElement) {
        if (iXMLElement != null) {
            // empty if block
        }
        this.idToLevel = new Hashtable();
        this.idToLevel.put(0, -1);
        this.idToLevel.put(1, 1);
    }

    private void readRuns(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("run");
        this.idToRun = new Hashtable();
        this.data.getRunList().clear();
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            Run run = new Run(this.data.getFactorList(), this.data.getFactorInteractionList());
            Integer n = this.parseId(iXMLElement2, "id", "run:id");
            this.idToRun.put(n, run);
            String string = iXMLElement2.getAttribute("idname", null);
            if (string == null) {
                throw new XmlIoError("run.idname not found.");
            }
            run.setId(string);
            Vector vector2 = iXMLElement2.getChildrenNamed("item");
            for (Object e2 : vector2) {
                IXMLElement iXMLElement3 = (IXMLElement)e2;
                Integer n2 = this.parseId(iXMLElement3, "factorId", "run.item:factorId");
                if (!this.idToFactor.containsKey(n2)) {
                    throw new XmlIoError("reference to factorId which does not exist");
                }
                Integer n3 = this.parseId(iXMLElement3, "levelId", "run.item:levelId");
                if (!this.idToLevel.containsKey(n3)) {
                    throw new XmlIoError("reference to levelId which does not exist");
                }
                run.setLevel(this.idToFactor.get(n2), this.idToLevel.get(n3));
            }
            run.updateFactorInteractionLevels();
            this.data.getRunList().add(run);
        }
    }

    private void readExpResults(IXMLElement iXMLElement) {
        int n = 0;
        String string = iXMLElement.getAttribute("replicates", null);
        if (string == null) {
            throw new XmlIoError("expresults:replicates not found.");
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XmlIoError("expresults:replicates could not be parsed.");
        }
        if (n < 0 || n >= 100) {
            throw new XmlIoError("expresults:replicates out of range.");
        }
        Vector vector = iXMLElement.getChildrenNamed("expresult");
        this.idToExpResults = new Hashtable();
        this.data.getExpResultsList().clear();
        for (Object e : vector) {
            Object object;
            IXMLElement iXMLElement2 = (IXMLElement)e;
            ExpResults expResults = new ExpResults(n);
            Integer n2 = this.parseId(iXMLElement2, "id", "expresult:id");
            this.idToExpResults.put(n2, expResults);
            Vector vector2 = iXMLElement2.getChildrenNamed("y");
            int n3 = -1;
            Object object2 = vector2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                IXMLElement iXMLElement3 = (IXMLElement)object;
                Double d = this.parseDouble(iXMLElement3, "value", "expresult.y:value");
                expResults.setResult(++n3, d);
            }
            if (n3 + 1 != n) {
                // empty if block
            }
            if ((object2 = iXMLElement2.getFirstChildNamed("yavg")) != null) {
                object = this.parseDouble((IXMLElement)object2, "value", "expresult.yavg:value");
                expResults.setYAvg((Double)object);
            }
            if ((object2 = iXMLElement2.getFirstChildNamed("sigma")) != null) {
                object = this.parseDouble((IXMLElement)object2, "value", "expresult.sigma:value");
                expResults.setSigma((Double)object);
            }
            this.data.getExpResultsList().add(expResults);
        }
    }

    private void readLevelAnalysis(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("levelanalysis");
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            String string = iXMLElement2.getAttribute("name", null);
            if (string == null) {
                throw new XmlIoError("indxpdata.levelanalysis:name not found.");
            }
            if (string.equals("YAvg")) {
                this.readLevelAnalysisSpec(iXMLElement2, this.data.getLevelAnalysisYAvg());
                continue;
            }
            if (string.equals("Sigma")) {
                this.readLevelAnalysisSpec(iXMLElement2, this.data.getLevelAnalysisSigma());
                continue;
            }
            throw new XmlIoError("indxpdata.levelanalysis:name invalid.");
        }
    }

    private Integer parseId(IXMLElement iXMLElement, String string, String string2) {
        Integer n;
        String string3 = iXMLElement.getAttribute(string, null);
        if (string3 == null) {
            throw new XmlIoError(string2 + " not found.");
        }
        try {
            n = Integer.valueOf(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XmlIoError(string2 + " could not be parsed.");
        }
        return n;
    }

    private Double parseDouble(IXMLElement iXMLElement, String string, String string2) {
        Double d;
        String string3 = iXMLElement.getAttribute(string, null);
        if (string3 == null) {
            throw new XmlIoError(string2 + " not found.");
        }
        if (string3.equals("null")) {
            return null;
        }
        try {
            d = Double.valueOf(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XmlIoError(string2 + " could not be parsed.");
        }
        return d;
    }

    private void readLevelAnalysisSpec(IXMLElement iXMLElement, LevelAnalysis levelAnalysis) {
        Vector vector = iXMLElement.getChildrenNamed("resultset");
        for (Object e : vector) {
            int n;
            Object object;
            Serializable serializable;
            IXMLElement iXMLElement2 = (IXMLElement)e;
            String string = iXMLElement2.getAttribute("type", null);
            if (string == null) {
                throw new XmlIoError("levelanalysis.resultset:type not found.");
            }
            if (string.equals("level")) {
                serializable = this.parseId(iXMLElement2, "levelId", "levelanalysis.resultset:levelId");
                if (!this.idToLevel.containsKey(serializable)) {
                    throw new XmlIoError("levelanalysis.resultset:levelId level does not exist.");
                }
                object = this.idToLevel.get(serializable);
                n = (Integer)object == -1 ? 1 : 0;
            } else if (string.equals("delta")) {
                n = 2;
            } else {
                throw new XmlIoError("levelanalysis.resultset:type invalid entry.");
            }
            serializable = iXMLElement2.getChildrenNamed("fiitem");
            object = ((Vector)serializable).iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                IXMLElement iXMLElement3 = (IXMLElement)e2;
                Integer n2 = this.parseId(iXMLElement3, "fiId", "resultset.fiitem:fiId");
                Double d = this.parseDouble(iXMLElement3, "value", "resultset.fiitem:value");
                if (!this.idToFactorInteraction.containsKey(n2)) {
                    throw new XmlIoError("resultset:fiitem:fiId refers to non-existent entry.");
                }
                FactorInteraction factorInteraction = this.idToFactorInteraction.get(n2);
                levelAnalysis.setStatValue(n, factorInteraction, d);
            }
        }
    }

    private void exportTxtFactors(BufferedWriter bufferedWriter) throws IOException {
        if (this.data.getFactorList() == null) {
            return;
        }
        bufferedWriter.write("Factors:\n");
        bufferedWriter.write("Name\tEntity\tUnit\tLow\tHigh\n");
        for (Factor factor : this.data.getFactorList()) {
            bufferedWriter.write(factor.getName() + "\t" + factor.getEntity() + "\t" + factor.getUnit() + "\t" + factor.getValueLow() + "\t" + factor.getValueHigh() + "\n");
        }
        bufferedWriter.write("\n");
    }

    private void exportTxtFactorInteractions(BufferedWriter bufferedWriter) throws IOException {
        if (this.data.getFactorInteractionList() == null) {
            return;
        }
        bufferedWriter.write("Factor Interactions:\n");
        bufferedWriter.write("Name\tAlias\tEntities\n");
        for (FactorInteraction factorInteraction : this.data.getFactorInteractionList()) {
            if (factorInteraction.isAliased()) {
                bufferedWriter.write(factorInteraction.getAliasName() + "\t" + factorInteraction.getDisplay() + "\t" + factorInteraction.getEntitiesDisplay() + "\n");
                continue;
            }
            bufferedWriter.write(factorInteraction.getDisplay() + "\t-\t" + factorInteraction.getEntitiesDisplay() + "\n");
        }
        bufferedWriter.write("\n");
    }

    private void exportTxtRuns(BufferedWriter bufferedWriter) throws IOException {
        if (this.data.getRunList() == null) {
            return;
        }
        bufferedWriter.write("Runs:\n");
        bufferedWriter.write("Run");
        for (FactorInteraction object : this.data.getFactorInteractionList()) {
            bufferedWriter.write("\t" + object.getDisplay());
        }
        bufferedWriter.write("\n");
        for (Run run : this.data.getRunList()) {
            bufferedWriter.write(run.getId());
            for (FactorInteraction factorInteraction : this.data.getFactorInteractionList()) {
                bufferedWriter.write("\t" + run.getFiLevel(factorInteraction).toString());
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.write("\n");
    }

    private String formatDouble(Double d) {
        if (d == null) {
            return "null";
        }
        Object[] objectArray = new Object[]{null};
        objectArray[0] = d;
        String string = String.format(this.locale, "%f", objectArray);
        objectArray[0] = null;
        return string;
    }

    private void exportTxtExpResults(BufferedWriter bufferedWriter) throws IOException {
        if (this.data.getExpResultsList() == null) {
            return;
        }
        bufferedWriter.write("Experimental Results:\n");
        bufferedWriter.write("Run");
        for (int i = 1; i <= this.data.replicateCount; ++i) {
            bufferedWriter.write("\ty" + i);
        }
        bufferedWriter.write("\ty-avg\ts*\n");
        for (ExpResults expResults : this.data.getExpResultsList()) {
            for (int i = 0; i < expResults.getReplicateCount(); ++i) {
                bufferedWriter.write(this.formatDouble(expResults.getResult(i)) + "\t");
            }
            bufferedWriter.write(this.formatDouble(expResults.getYAvg()) + "\t");
            bufferedWriter.write(this.formatDouble(expResults.getSigma()) + "\n");
        }
        bufferedWriter.write("\n");
    }

    private void exportTxtLevelAnalysis(BufferedWriter bufferedWriter, LevelAnalysis levelAnalysis) throws IOException {
        if (levelAnalysis == null) {
            return;
        }
        bufferedWriter.write("Level Analysis for " + levelAnalysis.getName() + "\n");
        bufferedWriter.write("Group");
        Object object = this.data.getFactorInteractionList().iterator();
        while (object.hasNext()) {
            FactorInteraction factorInteraction = object.next();
            bufferedWriter.write("\t" + factorInteraction.getDisplay());
        }
        bufferedWriter.write("\n");
        for (Object object2 : object = (Object)new int[]{0, 1, 2}) {
            switch (object2) {
                case 0: {
                    bufferedWriter.write("avg@+1");
                    break;
                }
                case 1: {
                    bufferedWriter.write("avg@-1");
                    break;
                }
                case 2: {
                    bufferedWriter.write("delta");
                }
            }
            for (FactorInteraction factorInteraction : this.data.getFactorInteractionList()) {
                bufferedWriter.write("\t" + this.formatDouble(levelAnalysis.getStatValue((int)object2, factorInteraction)));
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.write("\n");
    }
}

