/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.core;

import de.admadic.calculator.modules.indxp.core.Factor;
import de.admadic.calculator.modules.indxp.core.FactorInteraction;
import java.util.ArrayList;

public class FactorInteractionBuilder {
    ArrayList<Factor> factorsLink;
    ArrayList<FactorInteraction> factorInteractionsLink;

    public FactorInteractionBuilder(ArrayList<Factor> arrayList, ArrayList<FactorInteraction> arrayList2) {
        this.factorsLink = arrayList;
        this.factorInteractionsLink = arrayList2;
    }

    public void createFullFactorialInteractions() {
        this.factorInteractionsLink.clear();
        for (int i = 1; i <= this.factorsLink.size(); ++i) {
            this.createFactorialInteractionsWithLength(i);
        }
    }

    public void createFactorialInteractions(int n, int n2) {
        this.factorInteractionsLink.clear();
        if (n < 1 || n > this.factorsLink.size()) {
            throw new IllegalArgumentException("minLength out of range (1..factor.size())");
        }
        if (n2 < 1 || n2 > this.factorsLink.size()) {
            throw new IllegalArgumentException("maxLength out of range (1..factor.size())");
        }
        if (n > n2) {
            throw new IllegalArgumentException("minLength is larger than maxLength");
        }
        for (int i = n; i <= n2; ++i) {
            this.createFactorialInteractionsWithLength(i);
        }
    }

    private void appendFactors(ArrayList<Factor> arrayList, int n, int n2, int n3) {
        int n4 = this.factorsLink.size() - n3 + n2;
        for (int i = n; i <= n4; ++i) {
            arrayList.add(this.factorsLink.get(i));
            if (arrayList.size() > n3) {
                throw new Error("IDEData: factorial interactions design flaw.");
            }
            if (arrayList.size() == n3) {
                FactorInteraction factorInteraction = new FactorInteraction();
                for (Factor factor : arrayList) {
                    factorInteraction.addFactor(factor);
                }
                this.factorInteractionsLink.add(factorInteraction);
            } else {
                this.appendFactors(arrayList, i + 1, n2 + 1, n3);
            }
            arrayList.remove(arrayList.size() - 1);
        }
    }

    private void createFactorialInteractionsWithLength(int n) {
        ArrayList<Factor> arrayList = new ArrayList<Factor>();
        this.appendFactors(arrayList, 0, 0, n);
    }
}

