/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.math;

import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaNumber;

public class DMath {
    static final Double ln_base10 = 10.0;

    protected static void addsubimp(int n, CaDouble caDouble, CaNumber caNumber) {
        double d;
        if (caDouble.isNaN()) {
            return;
        }
        if (caNumber.isNaN()) {
            caDouble.setState(1);
            return;
        }
        if (caDouble.isInf()) {
            return;
        }
        if (caNumber.isInf()) {
            caDouble.setState(caNumber.getState());
            return;
        }
        double d2 = caNumber.doubleValue().value;
        double d3 = d = n >= 0 ? d2 : -d2;
        if (d >= 0.0) {
            if (caDouble.value > caDouble.upperlimit - d) {
                caDouble.setPosInf();
                return;
            }
        } else if (caDouble.value < caDouble.lowerlimit + d) {
            caDouble.setNegInf();
            return;
        }
        caDouble.value = n > 0 ? (caDouble.value += d2) : (caDouble.value -= d2);
    }

    protected static void mulimp(CaDouble caDouble, CaNumber caNumber) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caNumber.isNaN()) {
            caDouble.setNaN();
            return;
        }
        if (caDouble.isPosInf() && caNumber.isPosInf() || caDouble.isNegInf() && caNumber.isNegInf()) {
            caDouble.setPosInf();
            return;
        }
        if (caDouble.isPosInf() && caNumber.isNegInf() || caDouble.isNegInf() && caNumber.isPosInf()) {
            caDouble.setNegInf();
            return;
        }
        if (caDouble.isNotNormal() || caNumber.isNotNormal()) {
            caDouble.setNaN();
            return;
        }
        double d = caNumber.doubleValue().value;
        if (caDouble.value == 0.0 || d == 0.0) {
            caDouble.setZero();
            return;
        }
        caDouble.value *= d;
    }

    protected static void divimp(CaDouble caDouble, CaNumber caNumber) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caNumber.isNaN()) {
            caDouble.setNaN();
            return;
        }
        if (caDouble.isNotNormal()) {
            caDouble.setNaN();
            return;
        }
        if (caDouble.value == 0.0) {
            caDouble.setZero();
            return;
        }
        double d = caNumber.doubleValue().value;
        if (caDouble.value > 0.0) {
            if (caNumber.isPosInf()) {
                caDouble.setPosZero();
                return;
            }
            if (caNumber.isNegInf()) {
                caDouble.setNegZero();
                return;
            }
            if (caNumber.isPosZero()) {
                caDouble.setPosInf();
                return;
            }
            if (caNumber.isNegZero()) {
                caDouble.setNegInf();
                return;
            }
            if (d == 0.0) {
                caDouble.setPosInf();
                return;
            }
        } else {
            if (caNumber.isPosInf()) {
                caDouble.setNegZero();
                return;
            }
            if (caNumber.isNegInf()) {
                caDouble.setPosZero();
                return;
            }
            if (caNumber.isPosZero()) {
                caDouble.setNegInf();
                return;
            }
            if (caNumber.isNegZero()) {
                caDouble.setPosInf();
                return;
            }
            if (d == 0.0) {
                caDouble.setNegInf();
                return;
            }
        }
        caDouble.value /= d;
    }

    protected static void negimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            caDouble.setNegInf();
            return;
        }
        if (caDouble.isNegInf()) {
            caDouble.setPosInf();
            return;
        }
        if (caDouble.isPosZero()) {
            caDouble.setNegZero();
            return;
        }
        if (caDouble.isNegZero()) {
            caDouble.setPosZero();
            return;
        }
        if (caDouble.value > 0.0 && -caDouble.value < caDouble.lowerlimit) {
            caDouble.setNegInf();
            return;
        }
        if (caDouble.value < 0.0 && -caDouble.value > caDouble.upperlimit) {
            caDouble.setPosInf();
            return;
        }
        caDouble.value = -caDouble.value;
    }

    protected static void sqrimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        if (caDouble.value < 0.0) {
            caDouble.value = -caDouble.value;
        }
        if (caDouble.value > caDouble.upperlimit / caDouble.value) {
            caDouble.setPosInf();
            return;
        }
        caDouble.value *= caDouble.value;
    }

    protected static void sqrtimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        if (caDouble.value < 0.0) {
            caDouble.setNaN();
            return;
        }
        caDouble.value = Math.sqrt(caDouble.value);
    }

    protected static void lnimp(CaDouble caDouble, Double d) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        if (caDouble.value < 0.0) {
            caDouble.setNaN();
            return;
        }
        caDouble.value = Math.log(caDouble.value);
        if (d != null) {
            caDouble.value /= Math.log(d);
        }
    }

    protected static void expimp(CaDouble caDouble, Double d) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        if (caDouble.value > 0.0) {
            double d2 = Math.log(caDouble.upperlimit);
            if (d != null) {
                d2 /= Math.log(d);
            }
            if (caDouble.value > d2) {
                caDouble.setPosInf();
                return;
            }
        }
        if (d != null) {
            caDouble.value *= Math.log(d);
        }
        caDouble.value = Math.exp(caDouble.value);
    }

    protected static void expximp(CaDouble caDouble, CaDouble caDouble2) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        if (caDouble2.isNaN()) {
            caDouble.setNaN();
            return;
        }
        if (caDouble.isPosInf()) {
            caDouble.setPosInf();
            return;
        }
        if (caDouble.isNegInf()) {
            caDouble.setNaN();
            return;
        }
        if (caDouble.isPosZero()) {
            caDouble.setNaN();
            return;
        }
        if (caDouble.isNegZero()) {
            caDouble.setNaN();
            return;
        }
        caDouble.value = Math.log(caDouble.value);
        caDouble.value *= caDouble2.value;
        caDouble.value = Math.exp(caDouble.value);
    }

    protected static void sqrtximp(CaDouble caDouble, CaDouble caDouble2) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        if (caDouble2.isNaN()) {
            caDouble.setNaN();
            return;
        }
        if (caDouble.isPosInf()) {
            caDouble.setPosInf();
            return;
        }
        if (caDouble.isNegInf()) {
            caDouble.setNaN();
            return;
        }
        if (caDouble.isPosZero()) {
            caDouble.setNaN();
            return;
        }
        if (caDouble.isNegZero()) {
            caDouble.setNaN();
            return;
        }
        double d = Math.log(caDouble2.value);
        caDouble.value = Math.exp(d /= caDouble.value);
    }

    protected static void sinimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.sin(caDouble.value);
    }

    protected static void cosimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.cos(caDouble.value);
    }

    protected static void tanimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.tan(caDouble.value);
    }

    protected static void cotimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = 1.0 / Math.tan(caDouble.value);
    }

    protected static void arcsinimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.asin(caDouble.value);
    }

    protected static void arccosimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.acos(caDouble.value);
    }

    protected static void arctanimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.atan(caDouble.value);
    }

    protected static void arccotimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        if (caDouble.value == 0.0) {
            caDouble.setNaN();
            return;
        }
        caDouble.value = Math.atan(1.0 / caDouble.value);
    }

    protected static void sinhimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.sinh(caDouble.value);
    }

    protected static void coshimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.sinh(caDouble.value);
    }

    protected static void tanhimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.tanh(caDouble.value);
    }

    protected static void cothimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = 1.0 / Math.tanh(caDouble.value);
    }

    protected static void arsinhimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = Math.log(caDouble.value + Math.sqrt(caDouble.value * caDouble.value + 1.0));
    }

    protected static void arcoshimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = caDouble.value < 0.0 ? Math.log(caDouble.value - Math.sqrt(caDouble.value * caDouble.value - 1.0)) : Math.log(caDouble.value + Math.sqrt(caDouble.value * caDouble.value - 1.0));
    }

    protected static void artanhimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = 0.5 * Math.log((1.0 + caDouble.value) / (1.0 - caDouble.value));
    }

    protected static void arcothimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = 0.5 * Math.log((caDouble.value + 1.0) / (caDouble.value - 1.0));
    }

    protected static void secimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = 1.0 / Math.cos(caDouble.value);
    }

    protected static void cosecimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        caDouble.value = 1.0 / Math.sin(caDouble.value);
    }

    protected static double gammalnimp(double d) {
        double d2;
        double[] dArray = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double d3 = d2 = d;
        double d4 = d2 + 5.5;
        d4 -= (d2 + 0.5) * Math.log(d4);
        double d5 = 1.000000000190015;
        for (int i = 0; i < 6; ++i) {
            d5 += dArray[i] / (d3 += 1.0);
        }
        return -d4 + Math.log(2.5066282746310007 * d5 / d2);
    }

    protected static void gammaimp(CaDouble caDouble) {
        if (caDouble.isNaN()) {
            return;
        }
        if (caDouble.isPosInf()) {
            return;
        }
        if (caDouble.isNegInf()) {
            return;
        }
        if (caDouble.isPosZero()) {
            return;
        }
        if (caDouble.isNegZero()) {
            return;
        }
        double d = caDouble.value;
        if (d == 0.0) {
            caDouble.setNaN();
            return;
        }
        if (d > 0.0) {
            d = Math.exp(DMath.gammalnimp(d));
        } else {
            d = 1.0 - d;
            double d2 = Math.exp(DMath.gammalnimp(d));
            double d3 = Math.sin(Math.PI * d);
            d = Math.PI / d2 / d3;
        }
        if (Double.isNaN(d)) {
            caDouble.setNaN();
        } else if (Double.isInfinite(d)) {
            caDouble.setNaN();
        } else {
            caDouble.value = d;
        }
    }

    public static void add(CaDouble caDouble, CaNumber caNumber) {
        DMath.addsubimp(1, caDouble, caNumber);
    }

    public static void sub(CaDouble caDouble, CaNumber caNumber) {
        DMath.addsubimp(-1, caDouble, caNumber);
    }

    public static void mul(CaDouble caDouble, CaNumber caNumber) {
        DMath.mulimp(caDouble, caNumber);
    }

    public static void div(CaDouble caDouble, CaNumber caNumber) {
        DMath.divimp(caDouble, caNumber);
    }

    public static void neg(CaDouble caDouble) {
        DMath.negimp(caDouble);
    }

    public static void sqr(CaDouble caDouble) {
        DMath.sqrimp(caDouble);
    }

    public static void sqrt(CaDouble caDouble) {
        DMath.sqrtimp(caDouble);
    }

    public static void ln(CaDouble caDouble) {
        DMath.lnimp(caDouble, null);
    }

    public static void log(CaDouble caDouble) {
        DMath.lnimp(caDouble, ln_base10);
    }

    public static void exp(CaDouble caDouble) {
        DMath.expimp(caDouble, null);
    }

    public static void exp10(CaDouble caDouble) {
        DMath.expimp(caDouble, ln_base10);
    }

    public static void invx(CaDouble caDouble) {
        CaDouble caDouble2 = new CaDouble();
        caDouble.cloneTo(caDouble2);
        caDouble.setValue(1.0);
        DMath.divimp(caDouble, caDouble2);
    }

    public static void sin(CaDouble caDouble) {
        DMath.sinimp(caDouble);
    }

    public static void cos(CaDouble caDouble) {
        DMath.cosimp(caDouble);
    }

    public static void tan(CaDouble caDouble) {
        DMath.tanimp(caDouble);
    }

    public static void cot(CaDouble caDouble) {
        DMath.cotimp(caDouble);
    }

    public static void arcsin(CaDouble caDouble) {
        DMath.arcsinimp(caDouble);
    }

    public static void arccos(CaDouble caDouble) {
        DMath.arccosimp(caDouble);
    }

    public static void arctan(CaDouble caDouble) {
        DMath.arctanimp(caDouble);
    }

    public static void arccot(CaDouble caDouble) {
        DMath.arccotimp(caDouble);
    }

    public static void sinh(CaDouble caDouble) {
        DMath.sinhimp(caDouble);
    }

    public static void cosh(CaDouble caDouble) {
        DMath.coshimp(caDouble);
    }

    public static void tanh(CaDouble caDouble) {
        DMath.tanhimp(caDouble);
    }

    public static void coth(CaDouble caDouble) {
        DMath.cothimp(caDouble);
    }

    public static void arsinh(CaDouble caDouble) {
        DMath.arsinhimp(caDouble);
    }

    public static void arcosh(CaDouble caDouble) {
        DMath.arcoshimp(caDouble);
    }

    public static void artanh(CaDouble caDouble) {
        DMath.artanhimp(caDouble);
    }

    public static void arcoth(CaDouble caDouble) {
        DMath.arcothimp(caDouble);
    }

    public static void sec(CaDouble caDouble) {
        DMath.secimp(caDouble);
    }

    public static void cosec(CaDouble caDouble) {
        DMath.cosecimp(caDouble);
    }

    public static void expx(CaDouble caDouble, CaDouble caDouble2) {
        DMath.expximp(caDouble, caDouble2);
    }

    public static void sqrtx(CaDouble caDouble, CaDouble caDouble2) {
        DMath.sqrtximp(caDouble, caDouble2);
    }

    public static void gamma(CaDouble caDouble) {
        DMath.gammaimp(caDouble);
    }
}

