/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.fsm;

import de.admadic.calculator.fsm.Action;
import de.admadic.calculator.fsm.ActionListener;
import de.admadic.calculator.fsm.ActionTalkBack;
import de.admadic.calculator.fsm.Event;
import de.admadic.calculator.fsm.State;
import de.admadic.calculator.fsm.Transition;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public class FSM {
    public static final int STATUS_NONE = 0;
    public static final int STATUS_RUN = 1;
    public static final int STATUS_ACCEPT = 2;
    public static final int STATUS_ERROR = 3;
    Hashtable<String, Event> events;
    Hashtable<String, State> states;
    Hashtable<String, Transition> transitions;
    State startStateRef;
    State errorStateRef;
    Hashtable<String, State> endStatesRef;
    Hashtable<String, Hashtable<String, Transition>> transitionsFunction;
    LinkedList<Event> eventQueue;
    State currentState = null;
    int status = 0;
    ActionListener standardActionListener = null;
    LinkedList<ActionListener> acceptorListeners = null;
    LinkedList<ActionListener> errorListeners = null;

    public FSM() {
        this.initMembers();
    }

    public void initMembers() {
        this.events = new Hashtable();
        this.states = new Hashtable();
        this.transitions = new Hashtable();
        this.startStateRef = null;
        this.endStatesRef = new Hashtable();
        this.transitionsFunction = new Hashtable();
        this.standardActionListener = null;
        this.acceptorListeners = null;
        this.status = 0;
        this.eventQueue = new LinkedList();
    }

    public void registerStandardActionListener(ActionListener actionListener) {
        this.standardActionListener = actionListener;
    }

    public void addAcceptorListener(ActionListener actionListener) {
        if (this.acceptorListeners == null) {
            this.acceptorListeners = new LinkedList();
        }
        this.acceptorListeners.add(actionListener);
    }

    public void addErrorListener(ActionListener actionListener) {
        if (this.errorListeners == null) {
            this.errorListeners = new LinkedList();
        }
        this.errorListeners.add(actionListener);
    }

    public void addEvent(Event event) {
        this.events.put(event.getName(), event);
    }

    public void addState(State state) {
        if (this.standardActionListener != null) {
            state.addActionListener(this.standardActionListener);
        }
        this.states.put(state.getName(), state);
    }

    public void addTransition(Transition transition) {
        if (this.standardActionListener != null) {
            transition.addActionListener(this.standardActionListener);
        }
        this.transitions.put(transition.getName(), transition);
    }

    public State getState(String string) {
        return this.states.get(string);
    }

    public Event getEvent(String string) {
        return this.events.get(string);
    }

    public Transition getTransition(String string) {
        return this.transitions.get(string);
    }

    public void setStartState(String string) {
        State state;
        this.startStateRef = state = this.states.get(string);
    }

    public void setErrorState(String string) {
        State state;
        this.errorStateRef = state = this.states.get(string);
    }

    public void addEndState(String string) {
        State state = this.states.get(string);
        this.endStatesRef.put(string, state);
    }

    public boolean isEndState(State state) {
        return this.endStatesRef.get(state.getName()) != null;
    }

    public boolean isErrorState(State state) {
        if (this.errorStateRef == null) {
            return false;
        }
        return this.errorStateRef.getName().equals(state.getName());
    }

    public void buildTransitionFunction() {
        for (Transition transition : this.transitions.values()) {
            Hashtable<String, Transition> hashtable = this.transitionsFunction.get(transition.getSourceState().getName());
            if (hashtable == null) {
                hashtable = new Hashtable();
                this.transitionsFunction.put(transition.getSourceState().getName(), hashtable);
            }
            hashtable.put(transition.getEvent().getName(), transition);
        }
    }

    public void fsmStart() {
        this.fsmEnterState(this.startStateRef, null);
        this.status = 1;
    }

    public void fsmAddEvent(String string) {
        Event event = this.events.get(string);
        if (event == null) {
            System.err.println("addEventToQueue: no such event: " + string);
            return;
        }
        this.eventQueue.add(event);
    }

    public void fsmDoEvent(String string) {
        this.fsmAddEvent(string);
        this.fsmProcessEventQueue(10);
    }

    public boolean fsmIsEventQueueEmpty() {
        return this.eventQueue.isEmpty();
    }

    public void fsmProcessEventQueue(int n) {
        Event event;
        for (int i = 0; i < n && (event = this.eventQueue.poll()) != null; ++i) {
            this.fsmDoEvent(event);
        }
    }

    public void fsmDoEvent(Event event) {
        State state = null;
        State state2 = null;
        Transition transition = null;
        state = this.currentState;
        transition = this.findTransition(state, event);
        if (transition == null) {
            System.out.println("Error: could not find transition for (" + state.getName() + ")-[" + event.getName() + "]->");
            return;
        }
        state2 = transition.getDestinationState();
        if (!this.fsmLeaveState(state, event)) {
            return;
        }
        if (!this.fsmTransit(transition, event)) {
            return;
        }
        if (!this.fsmEnterState(state2, event)) {
            return;
        }
    }

    public Transition findTransition(State state, Event event) {
        Transition transition = null;
        Hashtable<String, Transition> hashtable = null;
        hashtable = this.transitionsFunction.get(state.getName());
        if (hashtable == null) {
            return null;
        }
        transition = hashtable.get(event.getName());
        return transition;
    }

    public void updateActionTalkBack(ActionTalkBack actionTalkBack) {
        if (actionTalkBack.nextEvent == null && actionTalkBack.nextEventName != null && !actionTalkBack.nextEventName.equals("")) {
            actionTalkBack.nextEvent = this.events.get(actionTalkBack.nextEventName);
        }
        if (actionTalkBack.nextState == null && actionTalkBack.nextStateName != null && !actionTalkBack.nextStateName.equals("")) {
            actionTalkBack.nextState = this.states.get(actionTalkBack.nextStateName);
        }
    }

    public boolean fsmEnterState(State state, Event event) {
        ActionTalkBack actionTalkBack;
        ActionListener actionListener;
        Action action;
        Iterator<ActionListener> iterator = state.getActionListenerIterator();
        if (iterator != null) {
            action = new Action(3, null, event, state, null);
            while (iterator.hasNext()) {
                actionListener = iterator.next();
                actionTalkBack = new ActionTalkBack();
                actionListener.actionPerformed(action, actionTalkBack);
                if (actionTalkBack.resultSuccess) continue;
                this.updateActionTalkBack(actionTalkBack);
                if (actionTalkBack.nextEvent != null) {
                    this.fsmAddEvent(actionTalkBack.nextEvent.getName());
                }
                if (actionTalkBack.nextState == null) continue;
                this.fsmEnterState(actionTalkBack.nextState, null);
                return false;
            }
        }
        this.currentState = state;
        if (this.isEndState(state)) {
            this.status = 2;
            iterator = null;
            if (this.acceptorListeners != null) {
                iterator = this.acceptorListeners.iterator();
            }
            if (iterator != null) {
                action = new Action(4, null, event, state, null);
                while (iterator.hasNext()) {
                    actionListener = iterator.next();
                    actionTalkBack = new ActionTalkBack();
                    actionListener.actionPerformed(action, actionTalkBack);
                    if (actionTalkBack.resultSuccess) continue;
                    System.err.println("Warning: ActionTalkBack with error in an EndState!");
                }
            }
        }
        if (this.isErrorState(state)) {
            this.status = 3;
            iterator = null;
            if (this.errorListeners != null) {
                iterator = this.errorListeners.iterator();
            }
            if (iterator != null) {
                action = new Action(5, null, event, state, null);
                while (iterator.hasNext()) {
                    actionListener = iterator.next();
                    actionTalkBack = new ActionTalkBack();
                    actionListener.actionPerformed(action, actionTalkBack);
                    if (actionTalkBack.resultSuccess) continue;
                    System.err.println("Warning: ActionTalkBack with error in an ErrorState!");
                }
            }
        }
        return true;
    }

    public boolean fsmLeaveState(State state, Event event) {
        Iterator<ActionListener> iterator = state.getActionListenerIterator();
        if (iterator != null) {
            Action action = new Action(1, state, event, null, null);
            while (iterator.hasNext()) {
                ActionListener actionListener = iterator.next();
                ActionTalkBack actionTalkBack = new ActionTalkBack();
                actionListener.actionPerformed(action, actionTalkBack);
                if (actionTalkBack.resultSuccess) continue;
                this.updateActionTalkBack(actionTalkBack);
                if (actionTalkBack.nextEvent != null) {
                    this.fsmAddEvent(actionTalkBack.nextEvent.getName());
                }
                if (actionTalkBack.nextState != null) {
                    this.fsmEnterState(actionTalkBack.nextState, null);
                    return false;
                }
                if (actionTalkBack.nextEvent == null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean fsmTransit(Transition transition, Event event) {
        Iterator<ActionListener> iterator = transition.getActionListenerIterator();
        if (iterator != null) {
            Action action = new Action(2, transition.getSourceState(), transition.getEvent(), transition.getDestinationState(), transition);
            while (iterator.hasNext()) {
                ActionListener actionListener = iterator.next();
                ActionTalkBack actionTalkBack = new ActionTalkBack();
                actionListener.actionPerformed(action, actionTalkBack);
                if (actionTalkBack.resultSuccess) continue;
                this.updateActionTalkBack(actionTalkBack);
                if (actionTalkBack.nextEvent != null) {
                    this.fsmAddEvent(actionTalkBack.nextEvent.getName());
                }
                if (actionTalkBack.nextState != null) {
                    this.fsmEnterState(actionTalkBack.nextState, null);
                    return false;
                }
                return false;
            }
        }
        return true;
    }
}

