/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.core;

import java.util.Locale;
import java.util.Vector;

public class LocaleModelEntry {
    Locale locale;
    Locale displayLocale;
    public static final int TYPE_LANG = 1;
    public static final int TYPE_COUNTRY = 2;
    public static final int TYPE_LANG_AND_COUNTRY = 3;
    int type = 3;

    public LocaleModelEntry(Locale locale, Locale locale2) {
        this(locale, locale2, 3);
    }

    public LocaleModelEntry(Locale locale, Locale locale2, int n) {
        this.locale = locale;
        this.displayLocale = locale2;
        this.type = n;
        if (this.displayLocale == null) {
            this.displayLocale = Locale.getDefault();
        }
    }

    public String toString() {
        String string = this.locale.getCountry();
        String string2 = this.locale.getLanguage();
        Object object = "";
        switch (this.type) {
            case 1: {
                object = (String)object + (string2.equals("") ? " " : string2);
                object = (String)object + "\t";
                object = (String)object + this.locale.getDisplayLanguage(this.displayLocale);
                break;
            }
            case 2: {
                object = (String)object + (string.equals("") ? " " : string);
                object = (String)object + "\t";
                object = (String)object + this.locale.getDisplayCountry(this.displayLocale);
                break;
            }
            default: {
                object = (String)object + (string2.equals("") ? " " : string2);
                object = (String)object + "\t";
                object = (String)object + (string.equals("") ? " " : string);
                object = (String)object + "\t";
                object = (String)object + this.locale.getDisplayName(this.displayLocale);
            }
        }
        return object;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getDisplayLocale() {
        return this.displayLocale;
    }

    public static Vector<LocaleModelEntry> getLocaleList(boolean bl, Locale localeArray) {
        Vector<LocaleModelEntry> vector = new Vector<LocaleModelEntry>();
        Locale[] localeArray2 = Locale.getAvailableLocales();
        if (bl) {
            Locale[] localeArray3 = localeArray;
            int n = 3;
            vector.add(new LocaleModelEntry(Locale.ENGLISH, (Locale)localeArray3, n));
            vector.add(new LocaleModelEntry(Locale.FRENCH, (Locale)localeArray3, n));
            vector.add(new LocaleModelEntry(Locale.GERMAN, (Locale)localeArray3, n));
            vector.add(new LocaleModelEntry(Locale.ITALIAN, (Locale)localeArray3, n));
            vector.add(new LocaleModelEntry(Locale.CHINESE, (Locale)localeArray3, n));
            vector.add(new LocaleModelEntry(Locale.JAPANESE, (Locale)localeArray3, n));
            vector.add(new LocaleModelEntry(Locale.KOREAN, (Locale)localeArray3, n));
            vector.add(null);
        }
        for (Locale locale : localeArray2) {
            vector.add(new LocaleModelEntry(locale, (Locale)localeArray, 3));
        }
        return vector;
    }

    public static Vector<LocaleModelEntry> getLanguageList(boolean bl, Locale stringArray) {
        Vector<LocaleModelEntry> vector = new Vector<LocaleModelEntry>();
        String[] stringArray2 = Locale.getISOLanguages();
        if (bl) {
            String[] stringArray3 = stringArray;
            int n = 1;
            vector.add(new LocaleModelEntry(Locale.ENGLISH, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.FRENCH, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.GERMAN, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.ITALIAN, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.CHINESE, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.JAPANESE, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.KOREAN, (Locale)stringArray3, n));
            vector.add(null);
        }
        for (String string : stringArray2) {
            vector.add(new LocaleModelEntry(new Locale(string, ""), (Locale)stringArray, 1));
        }
        return vector;
    }

    public static Vector<LocaleModelEntry> getCountryList(boolean bl, Locale stringArray) {
        Vector<LocaleModelEntry> vector = new Vector<LocaleModelEntry>();
        String[] stringArray2 = Locale.getISOCountries();
        if (bl) {
            String[] stringArray3 = stringArray;
            int n = 2;
            vector.add(new LocaleModelEntry(Locale.US, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.UK, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.GERMANY, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.FRANCE, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.CANADA, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.ITALY, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.CHINA, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.JAPAN, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.KOREA, (Locale)stringArray3, n));
            vector.add(new LocaleModelEntry(Locale.TAIWAN, (Locale)stringArray3, n));
            vector.add(null);
        }
        for (String string : stringArray2) {
            vector.add(new LocaleModelEntry(new Locale("", string), (Locale)stringArray, 2));
        }
        return vector;
    }

    public static int getFirstMatchForLanguage(Vector<LocaleModelEntry> vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            LocaleModelEntry localeModelEntry = vector.get(i);
            if (localeModelEntry == null || localeModelEntry.getLocale() == null || localeModelEntry.getLocale().getLanguage() == null || !localeModelEntry.getLocale().getLanguage().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstMatchForCountry(Vector<LocaleModelEntry> vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            LocaleModelEntry localeModelEntry = vector.get(i);
            if (localeModelEntry == null || !localeModelEntry.getLocale().getCountry().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstMatchForLaCo(Vector<LocaleModelEntry> vector, String string, String string2) {
        boolean bl = string.equals("");
        boolean bl2 = string2.equals("");
        for (int i = 0; i < vector.size(); ++i) {
            LocaleModelEntry localeModelEntry = vector.get(i);
            if (localeModelEntry == null) continue;
            boolean bl3 = true;
            if (!bl2 && !localeModelEntry.getLocale().getCountry().equals(string2)) {
                bl3 = false;
            }
            if (!bl && !localeModelEntry.getLocale().getLanguage().equals(string)) {
                bl3 = false;
            }
            if (!bl3) continue;
            return i;
        }
        return -1;
    }
}

