/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.core;

import de.admadic.calculator.core.LocaleEvent;
import de.admadic.calculator.core.LocaleListener;
import de.admadic.calculator.core.LocaleNumberFormatEvent;
import de.admadic.calculator.core.LocaleProvider;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.event.EventListenerList;

public class LocaleManager
implements LocaleProvider {
    Hashtable<Integer, Locale> locales;
    boolean sameAsDefault;
    static final Integer I_LOCALE_DEFAULT = 0;
    static final Integer I_LOCALE_INPUT = 1;
    static final Integer I_LOCALE_OUTPUT = 2;
    static final Integer I_LOCALE_EXPORT = 3;
    EventListenerList listenerList = new EventListenerList();

    public LocaleManager() {
        this.locales = new Hashtable();
    }

    private Integer idToItg(int n) {
        switch (n) {
            case 0: {
                return I_LOCALE_DEFAULT;
            }
            case 1: {
                return I_LOCALE_INPUT;
            }
            case 2: {
                return I_LOCALE_OUTPUT;
            }
            case 3: {
                return I_LOCALE_EXPORT;
            }
        }
        return I_LOCALE_DEFAULT;
    }

    @Override
    public Locale getDefaultLocale() {
        return this.locales.get(I_LOCALE_DEFAULT);
    }

    public Locale getLocale(int n) {
        Integer n2 = this.idToItg(n);
        if (!this.locales.containsKey(n2)) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.locales.get(n2);
    }

    public void setLocale(int n, Locale locale) {
        Integer n2 = this.idToItg(n);
        this.locales.put(n2, locale);
    }

    public void setAllLocales(Locale locale) {
        this.locales.put(I_LOCALE_DEFAULT, locale);
        this.locales.put(I_LOCALE_INPUT, locale);
        this.locales.put(I_LOCALE_OUTPUT, locale);
        this.locales.put(I_LOCALE_EXPORT, locale);
    }

    public boolean isSameAsDefault() {
        return this.sameAsDefault;
    }

    public void setSameAsDefault(boolean bl) {
        this.sameAsDefault = bl;
    }

    @Override
    public Locale queryLocale(int n) {
        if (this.isSameAsDefault()) {
            n = 0;
        }
        return this.getLocale(n);
    }

    @Override
    public void addLocaleListener(LocaleListener localeListener) {
        this.listenerList.add(LocaleListener.class, localeListener);
    }

    @Override
    public void removeLocaleListener(LocaleListener localeListener) {
        this.listenerList.remove(LocaleListener.class, localeListener);
    }

    protected void fireLocaleChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        LocaleEvent localeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LocaleListener.class) continue;
            if (localeEvent == null) {
                localeEvent = new LocaleEvent(this);
            }
            ((LocaleListener)objectArray[i + 1]).localeChanged(localeEvent);
        }
    }

    protected void fireLocaleNumberFormatChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        LocaleNumberFormatEvent localeNumberFormatEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LocaleListener.class) continue;
            if (localeNumberFormatEvent == null) {
                localeNumberFormatEvent = new LocaleNumberFormatEvent(this);
            }
            ((LocaleListener)objectArray[i + 1]).localeNumberFormatChanged(localeNumberFormatEvent);
        }
    }

    public void notifyLocaleChanged() {
        this.fireLocaleChanged();
    }

    public void notifyLocaleNumberFormatChanged() {
        this.fireLocaleNumberFormatChanged();
    }
}

