/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.appmod;

import de.admadic.calculator.appmod.ModuleZipReaderException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModuleZipReader {
    String zipName;
    ZipFile zipFile;
    Vector<String> entries;
    boolean flgHasInstallCfg;
    String installCfgName;
    boolean flgHasLicenseTxt;
    String licenseTxtName;
    Properties installCfgProp;
    ArrayList<String> cfgEntries;
    ArrayList<String> cfgEntryTypes;

    public ModuleZipReader(String string) {
        this.zipName = string;
        this.entries = new Vector();
    }

    public void open() throws ModuleZipReaderException {
        if (this.zipFile != null) {
            return;
        }
        try {
            this.zipFile = new ZipFile(this.zipName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ModuleZipReaderException("Error opening ZIP file: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new ModuleZipReaderException("Error opening ZIP file: " + iOException.getMessage());
        }
    }

    public void close() throws ModuleZipReaderException {
        if (this.zipFile == null) {
            return;
        }
        try {
            this.zipFile.close();
        }
        catch (IOException iOException) {
            throw new ModuleZipReaderException("Error closing ZIP file: " + iOException.getMessage());
        }
        this.zipFile = null;
    }

    public void buildEntryList() throws ModuleZipReaderException {
        if (this.zipFile == null) {
            throw new ModuleZipReaderException("ZIP file not opened");
        }
        try {
            ZipEntry zipEntry;
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            while (enumeration.hasMoreElements() && (zipEntry = enumeration.nextElement()) != null) {
                String string = zipEntry.getName();
                this.entries.add(string);
                if (!string.toLowerCase().equals("install.cfg")) continue;
                this.flgHasInstallCfg = true;
                this.installCfgName = string;
            }
        }
        catch (Exception exception) {
            throw new ModuleZipReaderException("Error reading ZIP file entries: " + exception.getMessage());
        }
    }

    public boolean hasInstallCfg() {
        return this.flgHasInstallCfg;
    }

    public void readInstallCfg() throws ModuleZipReaderException {
        if (!this.flgHasInstallCfg) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ZipFile zipFile = new ZipFile(this.zipName);
            ZipEntry zipEntry = zipFile.getEntry(this.installCfgName);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            long l = zipEntry.getSize();
            if (l < 0L || l > Integer.MAX_VALUE) {
                throw new ModuleZipReaderException("entry too long or unknown: " + l);
            }
            byte[] byArray = new byte[(int)l];
            int n = bufferedInputStream.read(byArray);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
            inputStream = zipFile.getInputStream(zipEntry);
            this.installCfgProp = new Properties();
            this.installCfgProp.load(inputStream);
        }
        catch (IOException iOException) {
            throw new ModuleZipReaderException("Error reading install.cfg: " + iOException.getMessage());
        }
    }

    public void parseInstallCfg() throws ModuleZipReaderException {
        if (this.installCfgProp == null) {
            return;
        }
        this.cfgEntries = new ArrayList();
        this.cfgEntryTypes = new ArrayList();
        for (Object object : this.installCfgProp.keySet()) {
            String string = (String)object;
            String string2 = (String)this.installCfgProp.get(object);
            if (string.trim().toLowerCase().equals("version")) {
                if (string2.trim().toLowerCase().equals("1")) continue;
                throw new ModuleZipReaderException("Version not supported: " + string2);
            }
            if (string.startsWith("lib")) {
                this.cfgEntries.add(string2);
                this.cfgEntryTypes.add("lib");
                continue;
            }
            if (string.startsWith("mod")) {
                this.cfgEntries.add(string2);
                this.cfgEntryTypes.add("mod");
                continue;
            }
            if (!string.startsWith("lic")) continue;
            this.cfgEntries.add(string2);
            this.cfgEntryTypes.add("lic");
        }
    }

    public Vector<String> getEntries(String string) {
        Vector<String> vector = null;
        if (this.cfgEntryTypes == null) {
            return null;
        }
        int n = Collections.frequency(this.cfgEntryTypes, string);
        if (n == 0) {
            return null;
        }
        vector = new Vector<String>();
        for (int i = 0; i < this.cfgEntryTypes.size(); ++i) {
            String string2 = this.cfgEntryTypes.get(i);
            if (!string2.equals(string)) continue;
            vector.add(this.cfgEntries.get(i));
        }
        return vector;
    }

    public void extractFileTo(String string, File file) throws ModuleZipReaderException {
        byte[] byArray = new byte[16384];
        try {
            int n;
            ZipEntry zipEntry = this.zipFile.getEntry(string);
            InputStream inputStream = this.zipFile.getInputStream(zipEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            while ((n = bufferedInputStream.read(byArray)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new ModuleZipReaderException("Error reading ZIP file: " + iOException.getMessage());
        }
    }

    public void extractJarInfo(String string) throws ModuleZipReaderException {
        try {
            ZipFile zipFile = new ZipFile(this.zipName);
            ZipEntry zipEntry = zipFile.getEntry(string);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            Manifest manifest = jarInputStream.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            for (Object object : attributes.keySet()) {
                Object object2 = attributes.get(object);
                System.out.println("attr: " + object + " => " + object2);
            }
        }
        catch (IOException iOException) {
            throw new ModuleZipReaderException("Error reading ZIP file: " + iOException.getMessage());
        }
    }

    public InputStream getStream(String string) {
        if (this.zipFile == null) {
            return null;
        }
        ZipEntry zipEntry = this.zipFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        try {
            return this.zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

