/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.appmod;

import de.admadic.calculator.appmod.ModuleSpec;
import de.admadic.calculator.appmod.ModuleZipReader;
import de.admadic.calculator.appmod.ModuleZipReaderException;
import de.admadic.util.VersionRecord;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ModuleUtil {
    protected ModuleUtil() {
    }

    public static ModuleSpec extractModuleSpec(File file) {
        String string = file.getName();
        string.toLowerCase();
        if (string.endsWith(".jar")) {
            return ModuleUtil.extractModuleSpecImplJar(file);
        }
        if (string.endsWith(".zip")) {
            return ModuleUtil.extractModuleSpecImplZip(file);
        }
        return null;
    }

    public static ModuleSpec extractModuleSpecImplZip(File file) {
        ModuleSpec moduleSpec = null;
        ModuleZipReader moduleZipReader = new ModuleZipReader(file.toString());
        try {
            moduleZipReader.open();
            moduleZipReader.buildEntryList();
        }
        catch (ModuleZipReaderException moduleZipReaderException) {
            return null;
        }
        try {
            if (!moduleZipReader.hasInstallCfg()) {
                return null;
            }
            moduleZipReader.readInstallCfg();
            moduleZipReader.parseInstallCfg();
        }
        catch (ModuleZipReaderException moduleZipReaderException) {
            return null;
        }
        Vector<String> vector = moduleZipReader.getEntries("mod");
        if (vector == null || vector.size() < 1) {
            return null;
        }
        String string = vector.firstElement();
        InputStream inputStream = moduleZipReader.getStream(string);
        moduleSpec = ModuleUtil.extractModuleSpec(inputStream);
        return moduleSpec;
    }

    protected static ModuleSpec extractModuleSpecImplJar(File file) {
        Manifest manifest;
        ModuleSpec moduleSpec = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            if (jarFile == null) {
                return null;
            }
            manifest = jarFile.getManifest();
            if (manifest == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        moduleSpec = ModuleUtil.extractModuleSpec(manifest);
        return moduleSpec;
    }

    public static ModuleSpec extractModuleSpec(InputStream inputStream) {
        Manifest manifest;
        ModuleSpec moduleSpec = null;
        JarInputStream jarInputStream = null;
        try {
            jarInputStream = new JarInputStream(inputStream);
            if (jarInputStream == null) {
                return null;
            }
            manifest = jarInputStream.getManifest();
            if (manifest == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        moduleSpec = ModuleUtil.extractModuleSpec(manifest);
        return moduleSpec;
    }

    public static ModuleSpec extractModuleSpec(Manifest manifest) {
        ModuleSpec moduleSpec = null;
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return null;
        }
        String string = attributes.getValue("X-admaDIC-Module-Name");
        String string2 = attributes.getValue("X-admaDIC-Module-ClassName");
        String string3 = attributes.getValue("X-admaDIC-Req-App-Ver");
        if (string != null && string2 != null) {
            moduleSpec = new ModuleSpec(string, string2, true);
            if (string3 != null) {
                moduleSpec.setRequiredAppVersion(VersionRecord.valueOf(string3));
            }
        }
        return moduleSpec;
    }

    public static Vector<ModuleSpec> scanModuleSpecs(File file) {
        File[] fileArray;
        Vector<ModuleSpec> vector = new Vector<ModuleSpec>();
        for (File file2 : fileArray = file.listFiles()) {
            ModuleSpec moduleSpec;
            String string;
            if (file2 == null || file2.isDirectory() || !(string = file2.getName()).toLowerCase().endsWith(".jar") || (moduleSpec = ModuleUtil.extractModuleSpec(file2)) == null) continue;
            vector.add(moduleSpec);
        }
        return vector;
    }
}

