/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.appmod;

import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.appmod.IModule;
import de.admadic.calculator.appmod.ModuleSpec;
import de.admadic.util.VersionRecord;
import java.lang.reflect.Constructor;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ModuleManager {
    static final boolean LOG = true;
    final Logger logger = Logger.getLogger("de.admadic");
    Vector<IModule> modules = new Vector();
    Vector<ModuleSpec> moduleSpecs = new Vector();

    public void add(IModule iModule) {
        this.modules.add(iModule);
    }

    public void remove(IModule iModule) {
        this.modules.remove(iModule);
    }

    public int getModuleCount() {
        return this.modules.size();
    }

    public IModule getModule(int n) {
        return this.modules.elementAt(n);
    }

    public void add(ModuleSpec moduleSpec) {
        this.moduleSpecs.add(moduleSpec);
        if (this.logger != null) {
            this.logger.fine("adding ModuleSpec: " + moduleSpec.getDiagnosticInfo());
        }
    }

    public void remove(ModuleSpec moduleSpec) {
        this.moduleSpecs.remove(moduleSpec);
        if (this.logger != null) {
            this.logger.fine("removing ModuleSpec: " + moduleSpec.getDiagnosticInfo());
        }
    }

    public int getModuleSpecCount() {
        return this.moduleSpecs.size();
    }

    public ModuleSpec getModuleSpec(int n) {
        return this.moduleSpecs.elementAt(n);
    }

    public void collectDescriptions() {
        for (ModuleSpec moduleSpec : this.moduleSpecs) {
            if (!moduleSpec.isEnabled()) {
                if (this.logger == null) continue;
                this.logger.fine("module skipped (not enabled): " + moduleSpec.getName());
                continue;
            }
            this.retrieveDescription(moduleSpec);
        }
    }

    private void retrieveDescription(ModuleSpec moduleSpec) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(moduleSpec.getClassName());
            Constructor<?> constructor = clazz.getConstructor(null);
            Object obj = constructor.newInstance(null);
            IModule iModule = (IModule)obj;
            this.add(iModule);
            if (this.logger != null) {
                this.logger.fine("module successfully accessed: " + moduleSpec.getName());
            }
        }
        catch (Exception exception) {
            if (this.logger != null) {
                this.logger.fine("module could not be accessed, disabling: " + moduleSpec.getName() + " (cause: " + exception.getClass().getName() + ": " + exception.getMessage() + ")");
            }
            moduleSpec.setEnabled(false);
        }
    }

    public void initializeModules(IAppContext iAppContext) {
        for (IModule iModule : this.modules) {
            iModule.initialize(iAppContext);
        }
    }

    public void createModulesMenu(JMenu jMenu) {
        int n = 0;
        for (IModule iModule : this.modules) {
            JMenu jMenu2 = iModule.createModuleMenu();
            if (jMenu2 == null) continue;
            jMenu.add(jMenu2);
            ++n;
        }
        if (n == 0) {
            JMenuItem jMenuItem = new JMenuItem("<none>");
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        }
    }

    public Vector<ModuleSpec> validateVersionRequirements(VersionRecord versionRecord) {
        Vector<ModuleSpec> vector = null;
        for (ModuleSpec moduleSpec : this.moduleSpecs) {
            VersionRecord versionRecord2;
            if (!moduleSpec.isEnabled() || (versionRecord2 = moduleSpec.getRequiredAppVersion()) == null || versionRecord2.compareTo(versionRecord, 3) <= 0) continue;
            if (vector == null) {
                vector = new Vector<ModuleSpec>();
            }
            moduleSpec.setEnabled(false);
            vector.add(moduleSpec);
        }
        return vector;
    }
}

