/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator;

import de.admadic.calculator.CalcLog;
import de.admadic.calculator.appctx.AppContext;
import de.admadic.calculator.appmod.ModuleManager;
import de.admadic.calculator.core.LocaleManager;
import de.admadic.calculator.ui.CalcLaFManager;
import de.admadic.calculator.ui.CfgCalc;
import de.admadic.calculator.ui.SimpleCalcV0;
import de.admadic.calculator.ui.UpdateManager;
import de.admadic.laf.LaFManager;
import de.admadic.ui.util.SplashWindow;
import de.admadic.util.ClassPathExtender;
import de.admadic.util.PathManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class LaunchCalc {
    static final boolean LOG = true;
    Logger logger = null;
    AppContext appContext;
    ModuleManager modMan;
    PathManager pathMan;
    SplashWindow splash;
    ClassPathExtender cpe;
    CfgCalc cfg;
    CalcLog calcLog;
    LaFManager lafMan;
    LocaleManager locMan;

    public static void main(String[] stringArray) {
        LaunchCalc launchCalc = new LaunchCalc();
        launchCalc.init(stringArray);
        launchCalc.initCpe();
        launchCalc.run();
        launchCalc.shutdown();
    }

    public void setCpe(ClassPathExtender classPathExtender) {
        this.cpe = classPathExtender;
    }

    public void init(String[] stringArray) {
        if (stringArray != null) {
            // empty if block
        }
        this.pathMan = new PathManager();
        this.pathMan.init("admadic", "calculator", "1.2.0", this.getClass());
        this.cfg = new CfgCalc();
        this.cfg.initCfgPaths(this.pathMan);
        this.calcLog = new CalcLog();
        this.calcLog.init(this.pathMan);
        UpdateManager updateManager = new UpdateManager(this.cfg, this.pathMan);
        updateManager.initLogging();
        if (updateManager.isFresh()) {
            updateManager.detectInstalledVersions();
            updateManager.selectMergeSource();
        }
        this.cfg.initialize(true);
        if (updateManager.shouldMerge()) {
            updateManager.doMerge();
        }
        this.logger = Logger.getLogger("de.admadic");
    }

    public void initCpe() {
        if (this.cpe == null && this.cfg.getBooleanValue("main.classpath.useextender", false)) {
            this.cpe = new ClassPathExtender();
            String string = this.cfg.getStringValue("main.classpath.dirs", null);
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(":")) {
                    File file = new File(this.pathMan.getPathString(3), string2);
                    if (!file.isDirectory()) continue;
                    this.cpe.setURLs(file, "*.jar");
                }
                this.cpe.generateClassLoader();
            }
        }
    }

    void initSplash() {
        URL uRL = null;
        ImageIcon imageIcon = null;
        if (this.logger != null) {
            this.logger.fine("about to load the splash image");
        }
        if ((uRL = this.getClass().getClassLoader().getResource("de/admadic/calculator/ui/res/splash.png")) != null) {
            if (this.logger != null) {
                this.logger.fine("creating ImageIcon");
            }
            imageIcon = new ImageIcon(uRL);
        } else if (this.logger != null) {
            this.logger.fine("could not create splash image url");
        }
        if (this.logger != null) {
            this.logger.fine("creating splash window...");
        }
        this.splash = new SplashWindow(imageIcon, null, null, null, 143);
        this.splash.setDelayedClose(10000);
        this.splash.setUserClose(true);
        this.splash.setWaitForCompletion(true);
        if (this.logger != null) {
            this.logger.fine("splash window created...");
        }
    }

    public void run() {
        this.initSplash();
        this.splash.setVisible(true);
        this.splash.repaint();
        this.splash.updateStatus("Initializing...", 1);
        UIManager.getDefaults().put("Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}));
        this.lafMan = null;
        if (this.cfg.getBooleanValue("ui.laf.enable", false)) {
            if (this.logger != null) {
                this.logger.fine("init LaF...");
            }
            if (this.logger != null) {
                this.logger.fine("cpe = " + this.cpe);
            }
            this.lafMan = new LaFManager();
            CalcLaFManager.initLaFManager(this.lafMan, this.cfg, this.cpe != null ? this.cpe.getClassLoader() : this.getClass().getClassLoader(), this.pathMan);
        }
        this.appContext = new AppContext(this.cfg, this.pathMan, this.lafMan);
        this.appContext.setCfgModulesPrefix("mod.");
        this.modMan = new ModuleManager();
        this.appContext.setModuleManager(this.modMan);
        this.appContext.setSplashWindow(this.splash);
        this.locMan = new LocaleManager();
        this.appContext.setLocaleManager(this.locMan);
        this.splash.updateStatus("Initializing UI...", 10);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (LaunchCalc.this.cpe != null) {
                        // empty if block
                    }
                    SimpleCalcV0 simpleCalcV0 = new SimpleCalcV0(LaunchCalc.this.appContext);
                    simpleCalcV0.start();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            if (this.splash != null) {
                this.splash.notifyCompleted();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            String string = invocationTargetException.getClass().getName() + ": " + invocationTargetException.getMessage();
            if (throwable != null) {
                string = string + "\n" + throwable.getMessage();
            }
            if (this.splash != null) {
                this.splash.notifyCompleted();
            }
            JOptionPane.showMessageDialog(null, "Error starting the User Interface of the calculator:\n" + string + "\nPlease contact customer support.", "Error Starting the Calculator", 0);
            System.exit(0);
        }
    }

    public void shutdown() {
    }
}

