/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator;

import de.admadic.log.SimpleOneLineFormatter;
import de.admadic.util.PathManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import javax.swing.JOptionPane;

public class CalcLog {
    Properties props = new Properties();
    String logPath;
    String baseDir;
    Hashtable<String, Logger> loggers = new Hashtable();

    public void init(PathManager pathManager) {
        this.load(pathManager);
        this.setup(pathManager);
        this.initialMessage();
    }

    protected void initialMessage() {
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        Object object = "";
        while (enumeration.hasMoreElements()) {
            object = (String)object + enumeration.nextElement() + " ";
        }
        Logger logger = Logger.getLogger("de.admadic.calculator");
        logger.info("-------------------");
        logger.info("Logging has been set up for " + this.loggers.size() + " loggers: " + (String)object);
    }

    protected void error(String string) {
        System.err.println("Calculator: " + string);
    }

    protected void load(PathManager pathManager) {
        File file = null;
        try {
            file = new File(pathManager.getPathString(13) + "/log.cfg");
            if (!file.exists()) {
                file = new File(pathManager.getPathString(5) + "/log.cfg");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            this.props.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error("a cfg file could not be found!");
        }
        catch (IOException iOException) {
            this.error("a cfg file exists, but could not be read! (" + (file != null ? file.toString() : "<null>") + ")");
        }
    }

    protected void tryLogPath() {
        File file = new File(this.logPath);
        if (file.exists() || !file.mkdirs()) {
            // empty if block
        }
    }

    protected void setup(PathManager pathManager) {
        Object object;
        String string;
        Object object2;
        Object object3;
        int n;
        String string2 = this.props.getProperty("de.admadic.calculator.CalcLog.logpath");
        if (string2 != null) {
            File file = PathManager.expandFilename(string2);
            this.logPath = file.toString();
            this.logPath = string2;
        } else {
            this.logPath = pathManager.getPathString(16);
        }
        this.tryLogPath();
        if (!this.logPath.endsWith("/") && !this.logPath.endsWith(File.separator)) {
            this.logPath = this.logPath + File.separator;
        }
        int n2 = 0;
        string2 = this.props.getProperty("de.admadic.calculator.CalcLog.loggers");
        if (string2 != null) {
            n2 = Integer.parseInt(string2);
            for (n = 0; n < n2; ++n) {
                object3 = this.props.getProperty("de.admadic.calculator.CalcLog.logger" + n + ".name");
                if (object3 == null) {
                    object3 = "";
                }
                object2 = this.props.getProperty("de.admadic.calculator.CalcLog.logger" + n + ".level");
                string = this.props.getProperty("de.admadic.calculator.CalcLog.logger" + n + ".useparent");
                Logger logger = Logger.getLogger((String)object3);
                this.loggers.put((String)object3, logger);
                if (object2 != null) {
                    object2 = ((String)object2).toUpperCase();
                    try {
                        object = Level.parse((String)object2);
                        logger.setLevel((Level)object);
                    }
                    catch (Exception exception) {
                        this.error("level information could not be parsed: " + (String)object2);
                    }
                }
                if (string == null) continue;
                string.toLowerCase();
                if (string.equals("true")) {
                    logger.setUseParentHandlers(true);
                }
                if (!string.equals("false")) continue;
                logger.setUseParentHandlers(false);
            }
        }
        n = 0;
        string2 = this.props.getProperty("de.admadic.calculator.CalcLog.handlers");
        if (string2 != null) {
            n = Integer.parseInt(string2);
            for (int i = 0; i < n; ++i) {
                object3 = null;
                object2 = null;
                string = this.props.getProperty("de.admadic.calculator.CalcLog.handler" + i + ".formatter");
                object = this.props.getProperty("de.admadic.calculator.CalcLog.handler" + i + ".filename");
                if (string == null || object == null) continue;
                if (string.equals("txt")) {
                    object3 = new SimpleFormatter();
                } else if (string.equals("txt1")) {
                    object3 = new SimpleOneLineFormatter();
                } else if (string.equals("xml")) {
                    object3 = new XMLFormatter();
                } else {
                    this.error("invalid formatter value in cfg: " + string);
                    continue;
                }
                if (this.logPath != null) {
                    object = this.logPath + (String)object;
                }
                try {
                    object2 = new FileHandler((String)object, 100000, 5, true);
                    ((Handler)object2).setFormatter((Formatter)object3);
                    for (Logger logger : this.loggers.values()) {
                        logger.addHandler((Handler)object2);
                    }
                    continue;
                }
                catch (SecurityException securityException) {
                    JOptionPane.showMessageDialog(null, "Could not set up logging system: " + securityException.getMessage() + "\nPlease contact customer support.", "Error Starting Logging System", 0);
                    continue;
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "Could not set up logging system: " + iOException.getMessage() + "\nPlease contact customer support.", "Error Starting Logging System", 0);
                }
            }
        }
    }
}

