/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinTitlePane;
import com.l2fprod.gui.plaf.skin.Window;
import com.l2fprod.util.AccessUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public final class SkinRootPaneUI
extends BasicRootPaneUI {
    public static final int Frame_MAXIMIZED_BOTH = AccessUtils.getIntValue(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SkinRootPaneUI.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, "MAXIMIZED_BOTH");
    public static final int JRootPane_NONE = AccessUtils.getIntValue(class$javax$swing$JRootPane == null ? (class$javax$swing$JRootPane = SkinRootPaneUI.class$("javax.swing.JRootPane")) : class$javax$swing$JRootPane, "NONE");
    private Skin skin = SkinLookAndFeel.getSkin();
    private Window.FrameWindow title = null;
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private SkinTitlePane titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$javax$swing$JRootPane;
    static /* synthetic */ Class class$com$l2fprod$gui$plaf$skin$SkinTitlePane;

    public static int getExtendedState(Frame p_Frame) {
        return AccessUtils.getAsInt(p_Frame, "getExtendedState");
    }

    public static void setExtendedState(Frame p_Frame, int p_Value) {
        AccessUtils.setAsInt(p_Frame, "setExtendedState", p_Value);
    }

    public static int getWindowDecorationStyle(JRootPane p_Pane) {
        return AccessUtils.getAsInt(p_Pane, "getWindowDecorationStyle");
    }

    public static ComponentUI createUI(JComponent c) {
        return new SkinRootPaneUI();
    }

    private static Window translateSource(MouseEvent ev) {
        Window w;
        Object source = ev.getSource();
        if (source.getClass() == (class$com$l2fprod$gui$plaf$skin$SkinTitlePane == null ? (class$com$l2fprod$gui$plaf$skin$SkinTitlePane = SkinRootPaneUI.class$("com.l2fprod.gui.plaf.skin.SkinTitlePane")) : class$com$l2fprod$gui$plaf$skin$SkinTitlePane)) {
            SkinTitlePane titleSource = (SkinTitlePane)source;
            Window.FrameWindow win = (Window.FrameWindow)titleSource.getWindow();
            w = win.getMainFrame();
        } else {
            w = (Window)ev.getSource();
        }
        return w;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.root = (JRootPane)c;
        int style = SkinRootPaneUI.getWindowDecorationStyle(this.root);
        if (style != JRootPane_NONE) {
            this.installClientDecorations(this.root);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    void installBorder(JRootPane root) {
        int style = SkinRootPaneUI.getWindowDecorationStyle(root);
        if (style == JRootPane_NONE) {
            LookAndFeel.uninstallBorder(root);
        } else {
            this.skin.getFrame().installSkin(root);
        }
    }

    private void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(root);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        this.adjustIconAndBackground();
        if (this.window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void adjustIconAndBackground() {
        if (this.window != null) {
            this.title.setFrame(this.window);
            this.titlePane.enableActions();
            this.titlePane.windowSet();
            String[] colors = this.skin.getColors();
            boolean cont = true;
            for (int i = 0; i < colors.length && cont; ++i) {
                String string = colors[i];
                if (!string.equalsIgnoreCase("desktop")) continue;
                cont = false;
                try {
                    ColorUIResource background = new ColorUIResource(Color.decode(colors[i + 1]));
                    this.window.setBackground(background);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            Window target = this.title.getMainFrame();
            if (target instanceof JFrame) {
                JFrame current = (JFrame)target;
                Icon provided = this.titlePane.getWindow().getFrameIcon();
                Icon general = UIManager.getIcon("InternalFrame.icon");
                Icon toWork = provided;
                if (provided == null) {
                    toWork = general;
                }
                if (toWork != null) {
                    BufferedImage theIcon = new BufferedImage(toWork.getIconWidth(), toWork.getIconHeight(), 2);
                    Graphics graph = theIcon.getGraphics();
                    toWork.paintIcon(null, graph, 0, 0);
                    current.setIconImage(theIcon);
                }
            }
        }
    }

    private void resetIconAndBackground() {
        if (this.window != null) {
            this.window.setBackground(null);
            this.title.setFrame(null);
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        this.resetIconAndBackground();
        int style = SkinRootPaneUI.getWindowDecorationStyle(root);
        if (style == JRootPane_NONE) {
            root.repaint();
            root.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private JComponent createTitlePane(JRootPane root) {
        this.title = new Window.FrameWindow();
        SkinTitlePane titlePane = new SkinTitlePane(this.title){

            protected JMenu createSystemMenu() {
                JMenu menu = new JMenu("    ");
                menu.getPopupMenu().setLightWeightPopupEnabled(false);
                return menu;
            }
        };
        titlePane.setOpaque(false);
        return titlePane;
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = (SkinTitlePane)titlePane;
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private Window.FrameWindow getFrameWindow() {
        return this.title;
    }

    private Window getMainWindow() {
        return this.window;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            int style = SkinRootPaneUI.getWindowDecorationStyle(root);
            this.uninstallClientDecorations(root);
            if (style != JRootPane_NONE) {
                this.installClientDecorations(root);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (SkinRootPaneUI.getWindowDecorationStyle((JRootPane)e.getSource()) != JRootPane_NONE) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    public static void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        bounds.x += deltaX;
        bounds.y += deltaY;
        bounds.width += deltaWidth;
        bounds.height += deltaHeight;
        if (min != null) {
            int correction;
            if (bounds.width < min.width) {
                correction = min.width - bounds.width;
                if (deltaX != 0) {
                    bounds.x -= correction;
                }
                bounds.width = min.width;
            }
            if (bounds.height < min.height) {
                correction = min.height - bounds.height;
                if (deltaY != 0) {
                    bounds.y -= correction;
                }
                bounds.height = min.height;
            }
        }
    }

    public static int calculateCorner(Component c, int x, int y) {
        int xPosition = SkinRootPaneUI.calculatePosition(x, c.getWidth());
        int yPosition = SkinRootPaneUI.calculatePosition(y, c.getHeight());
        if (xPosition == -1 || yPosition == -1) {
            return -1;
        }
        return yPosition * 5 + xPosition;
    }

    public static int getCursor(int corner) {
        if (corner == -1) {
            return 0;
        }
        return cursorMapping[corner];
    }

    public static int calculatePosition(int spot, int width) {
        if (spot < 5) {
            return 0;
        }
        if (spot < 16) {
            return 1;
        }
        if (spot >= width - 5) {
            return 4;
        }
        if (spot >= width - 16) {
            return 3;
        }
        return 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent ev) {
            if (SkinRootPaneUI.getWindowDecorationStyle(SkinRootPaneUI.this.root) == JRootPane_NONE) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = SkinRootPaneUI.translateSource(ev);
            if (w != null) {
                w.toFront();
            }
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, SkinRootPaneUI.this.getTitlePane());
            if (SkinRootPaneUI.this.getTitlePane() != null && SkinRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset) && !SkinRootPaneUI.this.getFrameWindow().isMaximum() && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w.getWidth() - 5) {
                this.isMovingWindow = true;
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
            }
            if (SkinRootPaneUI.this.getFrameWindow().isResizable() && !SkinRootPaneUI.this.getFrameWindow().isShaded() && !SkinRootPaneUI.this.getFrameWindow().isMaximum()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
                this.dragCursor = SkinRootPaneUI.getCursor(SkinRootPaneUI.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && SkinRootPaneUI.this.window != null && !SkinRootPaneUI.this.window.isValid()) {
                SkinRootPaneUI.this.window.validate();
                SkinRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        public void mouseMoved(MouseEvent ev) {
            JRootPane root = SkinRootPaneUI.this.getRootPane();
            if (SkinRootPaneUI.getWindowDecorationStyle(root) == JRootPane_NONE) {
                return;
            }
            Window w = SkinRootPaneUI.translateSource(ev);
            int cursor = SkinRootPaneUI.getCursor(SkinRootPaneUI.calculateCorner(w, ev.getX(), ev.getY()));
            if (cursor != 0 && SkinRootPaneUI.this.getFrameWindow().isResizable() && !SkinRootPaneUI.this.getFrameWindow().isShaded() && !SkinRootPaneUI.this.getFrameWindow().isMaximum()) {
                w.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w.setCursor(SkinRootPaneUI.this.lastCursor);
            }
        }

        public void mouseDragged(MouseEvent ev) {
            Window w = SkinRootPaneUI.translateSource(ev);
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                Point windowPt = w.getLocationOnScreen();
                windowPt.x += pt.x - this.dragOffsetX;
                windowPt.y += pt.y - this.dragOffsetY;
                w.setLocation(windowPt);
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min = w.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        SkinRootPaneUI.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                        break;
                    }
                    case 9: {
                        SkinRootPaneUI.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 8: {
                        SkinRootPaneUI.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        SkinRootPaneUI.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        SkinRootPaneUI.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        SkinRootPaneUI.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 6: {
                        SkinRootPaneUI.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        SkinRootPaneUI.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                }
                if (!r.equals(startBounds) && SkinRootPaneUI.this.getFrameWindow().isResizable()) {
                    w.setBounds(r);
                    if (Boolean.TRUE.equals(AccessUtils.invoke(Toolkit.getDefaultToolkit(), "isDynamicLayoutActive", null, null))) {
                        w.validate();
                        SkinRootPaneUI.this.getRootPane().repaint();
                    }
                    SkinRootPaneUI.this.getFrameWindow().dispatchEvent(new ComponentEvent(SkinRootPaneUI.this.getMainWindow(), 101));
                }
            }
        }

        public void mouseEntered(MouseEvent ev) {
            Window w = SkinRootPaneUI.translateSource(ev);
            SkinRootPaneUI.this.lastCursor = w.getCursor();
            this.mouseMoved(ev);
        }

        public void mouseExited(MouseEvent ev) {
            Window w = SkinRootPaneUI.translateSource(ev);
            w.setCursor(SkinRootPaneUI.this.lastCursor);
        }

        public void mouseClicked(MouseEvent ev) {
            Window w = SkinRootPaneUI.translateSource(ev);
            if (!(w instanceof Frame)) {
                return;
            }
            Frame f = (Frame)w;
            Point convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), SkinRootPaneUI.this.getTitlePane());
            int state = SkinRootPaneUI.getExtendedState(f);
            if (SkinRootPaneUI.this.getTitlePane() != null && SkinRootPaneUI.this.getTitlePane().contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & Frame_MAXIMIZED_BOTH) != 0) {
                    SkinRootPaneUI.setExtendedState(f, state & ~Frame_MAXIMIZED_BOTH);
                } else {
                    SkinRootPaneUI.setExtendedState(f, state | Frame_MAXIMIZED_BOTH);
                }
                return;
            }
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (SkinRootPaneUI.getWindowDecorationStyle(root) != JRootPane_NONE && root.getUI() instanceof SkinRootPaneUI && (titlePane = ((SkinRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            if (!(root.getParent() instanceof Window && SkinRootPaneUI.getWindowDecorationStyle(root) != JRootPane_NONE || (cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize()) == null)) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (SkinRootPaneUI.getWindowDecorationStyle(root) != JRootPane_NONE && root.getUI() instanceof SkinRootPaneUI && (titlePane = ((SkinRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (SkinRootPaneUI.getWindowDecorationStyle(root) != JRootPane_NONE && root.getUI() instanceof SkinRootPaneUI && (titlePane = ((SkinRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (SkinRootPaneUI.getWindowDecorationStyle(root) != JRootPane_NONE && root.getUI() instanceof SkinRootPaneUI && (titlePane = ((SkinRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }
}

