/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DefaultButton
implements Icon,
Border,
UIResource,
Serializable {
    public transient Image topleft;
    public transient Image topright;
    public transient Image bottomleft;
    public transient Image bottomright;
    public transient Image top;
    public transient Image right;
    public transient Image bottom;
    public transient Image left;
    public transient Image center;
    protected int topHeight;
    protected int bottomHeight;
    protected int leftWidth;
    protected int rightWidth;
    protected int imageWidth;
    protected int imageHeight;
    protected int top_fill = 1;
    protected int right_fill = 1;
    protected int bottom_fill = 1;
    protected int left_fill = 1;
    protected int center_fill = 1;
    protected boolean tile;
    protected Insets insets;

    public void paint(Graphics g, int x, int y, int width, int height, Component b) {
        if (SkinUtils.DEBUG) {
            System.out.println("Painting (" + x + "," + y + "," + width + "x" + height + ") for " + b);
        }
        ImageUtils.paint(b, g, this.center, x + this.leftWidth, y + this.topHeight, width - this.leftWidth - this.rightWidth, height - this.topHeight - this.bottomHeight, false, this.center_fill);
        this.paintBorder(b, g, x, y, width, height);
        if (SkinUtils.DEBUG) {
            g.setColor(Color.black);
            g.drawRect(x + this.leftWidth, y + this.topHeight, width - this.leftWidth - this.rightWidth, height - this.topHeight - this.bottomHeight);
            g.drawLine(x + this.leftWidth, y, x + this.leftWidth, y + height);
            g.drawLine(x + width - this.rightWidth, y, x + width - this.rightWidth, y + height);
            g.drawLine(x, y + this.topHeight, x + width, y + this.topHeight);
            g.drawLine(x, y + height - this.bottomHeight, x + width, y + height - this.bottomHeight);
        }
    }

    public DefaultButton() {
    }

    public DefaultButton(Image bitmap, int imageWidth, int imageHeight, int topHeight, int rightWidth, int bottomHeight, int leftWidth) {
        this(bitmap, imageWidth, imageHeight, topHeight, rightWidth, bottomHeight, leftWidth, false);
    }

    public DefaultButton(Image top, Image bottom, Image left, Image right, Image topLeft, Image topRight, Image bottomLeft, Image bottomRight) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        this.topleft = topLeft;
        this.bottomleft = bottomLeft;
        this.topright = topRight;
        this.bottomright = bottomRight;
        this.topHeight = top != null ? top.getHeight(null) : (this.topleft != null ? this.topleft.getHeight(null) : 0);
        this.rightWidth = right != null ? right.getWidth(null) : 0;
        this.bottomHeight = bottom != null ? bottom.getHeight(null) : 0;
        this.leftWidth = left != null ? left.getWidth(null) : 0;
        this.insets = new Insets(top != null ? this.topHeight : 0, this.leftWidth, this.bottomHeight, this.rightWidth);
    }

    public DefaultButton(Image bitmap, int imageWidth, int imageHeight, int topHeight, int rightWidth, int bottomHeight, int leftWidth, boolean tile) {
        this.topHeight = topHeight;
        this.rightWidth = rightWidth;
        this.bottomHeight = bottomHeight;
        this.leftWidth = leftWidth;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.tile = tile;
        this.insets = new Insets(topHeight, leftWidth, bottomHeight, rightWidth);
        this.topleft = ImageUtils.grab(bitmap, 0, 0, leftWidth, topHeight);
        this.topright = ImageUtils.grab(bitmap, imageWidth - rightWidth, 0, rightWidth, topHeight);
        this.bottomleft = ImageUtils.grab(bitmap, 0, imageHeight - bottomHeight, leftWidth, bottomHeight);
        this.bottomright = ImageUtils.grab(bitmap, imageWidth - rightWidth, imageHeight - bottomHeight, rightWidth, bottomHeight);
        this.top = ImageUtils.grab(bitmap, leftWidth, 0, imageWidth - leftWidth - rightWidth, topHeight);
        if (rightWidth > 0) {
            this.right = ImageUtils.grab(bitmap, imageWidth - rightWidth, topHeight, rightWidth, imageHeight - topHeight - bottomHeight);
        }
        if (bottomHeight > 0) {
            this.bottom = ImageUtils.grab(bitmap, leftWidth, imageHeight - bottomHeight, imageWidth - leftWidth - rightWidth, bottomHeight);
        }
        if (leftWidth > 0) {
            this.left = ImageUtils.grab(bitmap, 0, topHeight, leftWidth, imageHeight - topHeight - bottomHeight);
        }
        this.center = ImageUtils.grab(bitmap, leftWidth, topHeight, imageWidth - leftWidth - rightWidth, imageHeight - topHeight - bottomHeight);
    }

    public void setCenterFill(int mode) {
        this.center_fill = mode;
    }

    public DefaultButton getDisabled() {
        DefaultButton b = new DefaultButton();
        b.topleft = ImageUtils.getDisabledImage(this.topleft);
        b.topright = ImageUtils.getDisabledImage(this.topright);
        b.bottomleft = ImageUtils.getDisabledImage(this.bottomleft);
        b.bottomright = ImageUtils.getDisabledImage(this.bottomright);
        b.top = ImageUtils.getDisabledImage(this.top);
        b.right = ImageUtils.getDisabledImage(this.right);
        b.bottom = ImageUtils.getDisabledImage(this.bottom);
        b.left = ImageUtils.getDisabledImage(this.left);
        b.center = ImageUtils.getDisabledImage(this.center);
        b.topHeight = this.topHeight;
        b.bottomHeight = this.bottomHeight;
        b.leftWidth = this.leftWidth;
        b.rightWidth = this.rightWidth;
        b.imageWidth = this.imageWidth;
        b.imageHeight = this.imageHeight;
        b.top_fill = this.top_fill;
        b.right_fill = this.right_fill;
        b.bottom_fill = this.bottom_fill;
        b.left_fill = this.left_fill;
        b.center_fill = this.center_fill;
        b.tile = this.tile;
        b.insets = this.insets;
        return b;
    }

    public DefaultButton getTopToBottom() {
        DefaultButton b = new DefaultButton();
        b.top = ImageUtils.flipHorizontally(this.bottom);
        b.topHeight = this.bottomHeight;
        b.top_fill = this.bottom_fill;
        b.topleft = ImageUtils.flipHorizontally(this.bottomleft);
        b.bottomleft = ImageUtils.flipHorizontally(this.topleft);
        b.topright = ImageUtils.flipHorizontally(this.bottomright);
        b.bottomright = ImageUtils.flipHorizontally(this.topright);
        b.bottom = ImageUtils.flipHorizontally(this.top);
        b.bottomHeight = this.topHeight;
        b.bottom_fill = this.top_fill;
        b.left = ImageUtils.flipHorizontally(this.left);
        b.leftWidth = this.leftWidth;
        b.left_fill = this.left_fill;
        b.right = ImageUtils.flipHorizontally(this.right);
        b.rightWidth = this.rightWidth;
        b.right_fill = this.right_fill;
        b.center = ImageUtils.flipHorizontally(this.center);
        b.center_fill = this.center_fill;
        b.imageWidth = this.imageWidth;
        b.imageHeight = this.imageHeight;
        b.tile = this.tile;
        b.insets = new Insets(this.insets.bottom, this.insets.left, this.insets.top, this.insets.right);
        return b;
    }

    public DefaultButton rotateCounterClockWise() {
        DefaultButton b = new DefaultButton();
        b.top = ImageUtils.rotateLeft(this.right);
        b.topHeight = this.rightWidth;
        b.top_fill = this.right_fill;
        b.topleft = ImageUtils.rotateLeft(this.topright);
        b.bottomleft = ImageUtils.rotateLeft(this.topleft);
        b.topright = ImageUtils.rotateLeft(this.bottomright);
        b.bottomright = ImageUtils.rotateLeft(this.bottomleft);
        b.bottom = ImageUtils.rotateLeft(this.left);
        b.bottomHeight = this.leftWidth;
        b.bottom_fill = this.left_fill;
        b.left = ImageUtils.rotateLeft(this.top);
        b.leftWidth = this.topHeight;
        b.left_fill = this.top_fill;
        b.right = ImageUtils.rotateLeft(this.bottom);
        b.rightWidth = this.bottomHeight;
        b.right_fill = this.bottom_fill;
        b.center = ImageUtils.rotateLeft(this.center);
        b.center_fill = this.center_fill;
        b.imageWidth = this.imageHeight;
        b.imageHeight = this.imageWidth;
        b.tile = this.tile;
        b.insets = new Insets(this.insets.left, this.insets.top, this.insets.right, this.insets.bottom);
        return b;
    }

    public DefaultButton rotateClockWise() {
        DefaultButton b = new DefaultButton();
        b.center = ImageUtils.rotateRight(this.center);
        b.center_fill = this.center_fill;
        b.top = ImageUtils.rotateRight(this.left);
        b.topHeight = this.leftWidth;
        b.top_fill = this.left_fill;
        b.right = ImageUtils.rotateRight(this.top);
        b.rightWidth = this.topHeight;
        b.right_fill = this.top_fill;
        b.bottom = ImageUtils.rotateRight(this.right);
        b.bottomHeight = this.rightWidth;
        b.bottom_fill = this.right_fill;
        b.left = ImageUtils.rotateRight(this.bottom);
        b.leftWidth = this.bottomHeight;
        b.left_fill = this.bottom_fill;
        b.topleft = ImageUtils.rotateRight(this.bottomleft);
        b.topright = ImageUtils.rotateRight(this.topleft);
        b.bottomleft = ImageUtils.rotateRight(this.bottomright);
        b.bottomright = ImageUtils.rotateRight(this.topright);
        b.imageWidth = this.imageHeight;
        b.imageHeight = this.imageWidth;
        b.tile = this.tile;
        b.insets = new Insets(this.leftWidth, this.bottomHeight, this.rightWidth, this.topHeight);
        return b;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.imageWidth, this.imageHeight);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public int getIconWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.imageHeight;
    }

    public int getIconHeight() {
        return this.getHeight();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String toString() {
        return "DefaultButton(" + this.getWidth() + "x" + this.getHeight() + ",center_fill=" + this.center_fill + ")";
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.center != null) {
            g.drawImage(this.center, x, y, c);
        }
    }

    public void paint(Graphics g, Component b) {
        this.paint(g, 0, 0, b);
    }

    public void paint(Graphics g, int x, int y, Component b) {
        this.paint(g, x, y, ((JComponent)b).getWidth(), ((JComponent)b).getHeight(), b);
    }

    public void paintBorder(Component b, Graphics g, int x, int y, int width, int height) {
        if (this.top != null) {
            ImageUtils.paint(b, g, this.top, x + (this.topleft != null ? this.leftWidth : 0), y, width - (this.topleft != null ? this.leftWidth : 0) - (this.topright != null ? this.rightWidth : 0), this.topHeight, false, this.top_fill);
        }
        if (this.right != null) {
            ImageUtils.paint(b, g, this.right, x + width - this.rightWidth, y + this.topHeight, this.rightWidth, height - this.topHeight - this.bottomHeight, false, this.right_fill);
        }
        if (this.bottom != null) {
            ImageUtils.paint(b, g, this.bottom, x + (this.topleft != null ? this.leftWidth : 0), y + height - this.bottomHeight, width - (this.topleft != null ? this.leftWidth : 0) - (this.topright != null ? this.rightWidth : 0), this.bottomHeight, false, this.bottom_fill);
        }
        if (this.left != null) {
            ImageUtils.paint(b, g, this.left, x, y + this.topHeight, this.leftWidth, height - this.topHeight - this.bottomHeight, false, this.left_fill);
        }
        if (this.topleft != null) {
            ImageUtils.paint(b, g, this.topleft, x, y, 0, 0, false, 0);
        }
        if (this.topright != null) {
            ImageUtils.paint(b, g, this.topright, x + width - this.topright.getWidth(null), y, 0, 0, false, 0);
        }
        if (this.bottomleft != null) {
            ImageUtils.paint(b, g, this.bottomleft, x, y + height - this.bottomleft.getHeight(null), 0, 0, false, 0);
        }
        if (this.bottomright != null) {
            ImageUtils.paint(b, g, this.bottomright, x + width - this.bottomright.getWidth(null), y + height - this.bottomright.getHeight(null), 0, 0, false, 0);
        }
    }

    public void paintWindow(Graphics g, int width, int height, int windowX, int windowY, int windowWidth, int windowHeight, Component b) {
        ImageUtils.paintWindow(b, g, this.center, this.leftWidth, this.topHeight, width - this.leftWidth - this.rightWidth, height - this.topHeight - this.bottomHeight, windowX, windowY, windowWidth, windowHeight, false, this.center_fill);
        this.paintBorder(b, g, 0, 0, width, height);
    }
}

